% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadGeneSet.R
\name{loadGeneSet}
\alias{loadGeneSet}
\title{Load gene set data}
\usage{
loadGeneSet(organism = "hsapiens",
  enrichDatabase = "geneontology_Biological_Process",
  enrichDatabaseFile = NULL, enrichDatabaseType = NULL,
  enrichDatabaseDescriptionFile = NULL, collapseMethod = "mean",
  hostName = "http://www.webgestalt.org/")
}
\arguments{
\item{organism}{Currently, WebGestaltR supports 12 organisms. Users can use the function
\code{listOrganism} to check available organisms. Users can also input \code{others} to
perform the enrichment analysis for other organisms not supported by WebGestaltR. For
other organisms, users need to provide the functional categories, interesting list and
reference list (for ORA method). Because WebGestaltR does not perform the ID mapping for
the other organisms, the above data should have the same ID type.}

\item{enrichDatabase}{The functional categories for the enrichment analysis. Users can use
the function \code{listGeneSet} to check the available functional databases for the
selected organism. Users can also input \code{others} to provide a custom functional
databases not supported by WebGestaltR for the selected organism.}

\item{enrichDatabaseFile}{If users set \code{organism} as \code{others} or set
\code{enrichDatabase} as \code{others}, users need to provide a GMT file as the functional
category for enrichment analysis. The extension of the file should be \code{gmt} and the
first column of the file is the category ID, the second one is the external link for the
category. Genes annotated to the category are from the third column. All columns are
separated by tabs.}

\item{enrichDatabaseType}{If users set \code{enrichDatabase} as \code{others}, WebGestaltR
will also perform ID mapping for the supplied GMT file. Thus, users need to set the ID
type of the genes in the \code{enrichDatabaseFile}. If users set \code{organism} as
\code{others}, users do not need to set this ID type because WebGestaltR will not perform
ID mapping for other organisms. The supported ID types of WebGestaltR for the selected
organism can be found by the function \code{listIdType}.}

\item{enrichDatabaseDescriptionFile}{Users can also provide a description file for the custom
\code{enrichDatabaseFile}. The extension of the description file should be \code{des}. The
description file contains two columns: the first column is the category ID that should be
exactly the same as the category ID in the custom \code{enrichDatabaseFile} and the second
column is the description of the category. All columns are separated by tabs.}

\item{collapseMethod}{The method to collapse duplicate IDs with scores. \code{mean},
\code{median}, \code{min} and \code{max} represent the mean, median, minimum and maximum
of scores for the duplicate IDs.}

\item{hostName}{The server URL for accessing data. Mostly for development purposes.}
}
\value{
A list of \code{geneSet}, \code{geneSetDes}, \code{geneSetDag}, \code{geneSetNet}, \code{standardId}.
\describe{
 \item{geneSet}{Gene set: A data frame with columns of "geneSet", "description", "genes"}
 \item{geneSetDes}{Description: A data frame with columns of two columns of gene set ID and description}
 \item{geneSetDag}{DAG: A edge list data frame of two columns of parent and child}
 \item{geneSetNet}{Network: A edge list data frame of two columns connecting nodes}
 \item{standardId}{The standard ID of the gene set}
}
}
\description{
Load gene set data
}
