% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.effect.MRT2arm}
\alias{wp.effect.MRT2arm}
\title{Effect size calculatator based on raw data for Multisite Randomized Trials with 2 Arms}
\usage{
wp.effect.MRT2arm(file)
}
\arguments{
\item{file}{The input data set.
The first column of the data is the ID variable, the second column represents cluster,
the third column is the outcome variable, and the fourth column is the condition variable (0 for control, 1 for condition).}
}
\value{
A list including effect size f.
}
\description{
This function is for effect size calculation for Multisite randomized trials (MRT) with 2 arms based on empirical data.
MRTs are a type of multilevel design for the situation when the entire cluster is randomly assigned to either a treatment arm or a contral arm \cite{(Liu, 2013)}.
The data from MRT can be analyzed in a two-level hierachical linear model, where the indicator variable for treatment assignment is included in first level. If a study contains multiple treatments, then mutiple indicators will be used.
Three types of tests are considered in the function: (1) The "main" type tests treatment main effect;
(2) The "site" type tests the variance of cluster/site means;
and (3) The "variance" type tests variance of treatment effects.
Details leading to power calculation can be found in \cite{Raudenbush (1997)} and \cite{Liu (2013)}.
This function is used to calculate the effect size with a input data set.
}
\examples{
\donttest{
#To calculate the effect size based on empirical data
wp.effect.MRT2arm (MRT2)
#  Effect size for MRT2arm
#  
#  f
#  -0.2986755
#  
#  NOTE: f is the effect size.
#  URL: http://psychstat.org/mrt2arm
}

}
\references{
Liu, X. S. (2013). Statistical power analysis for the social and behavioral sciences: basic and advanced techniques. Routledge.

Raudenbush, S. W. (1997). Statistical analysis and optimal design for cluster randomized trials. Psychological Methods, 2(2), 173.
}
