% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_links.R
\name{plot_links}
\alias{plot_links}
\title{Visualizing links in 'WhatsApp' chat logs}
\usage{
plot_links(
  data,
  names = "all",
  starttime = "1960-01-01 00:00",
  endtime = "2200-01-01 00:00",
  use_domains = TRUE,
  exclude_long = 50,
  min_occur = 1,
  return_data = FALSE,
  link_vec = "all",
  plot = "bar",
  exclude_sm = FALSE
)
}
\arguments{
\item{data}{A 'WhatsApp' chatlog that was parsed with \code{\link[WhatsR]{parse_chat}}.}

\item{names}{A vector of author names that the plots will be restricted to.}

\item{starttime}{Datetime that is used as the minimum boundary for exclusion. Is parsed with \code{\link[anytime]{anytime}}. Standard format is "yyyy-mm-dd hh:mm". Is interpreted as UTC to be compatible with 'WhatsApp' timestamps.}

\item{endtime}{Datetime that is used as the maximum boundary for exclusion. Is parsed with \code{\link[anytime]{anytime}}. Standard format is "yyyy-mm-dd hh:mm". Is interpreted as UTC to be compatible with 'WhatsApp' timestamps.}

\item{use_domains}{If TRUE, links are shortened to domains. This includes the inputs in link_vec. Default is TRUE.}

\item{exclude_long}{Either NA or a numeric value. If numeric value is provided, removes all links/domains longer than x characters. Default is 50.}

\item{min_occur}{The minimum number of occurrences a link has to have to be included in the visualization. Default is 1.}

\item{return_data}{If TRUE, returns the subset data frame. Default is FALSE.}

\item{link_vec}{A vector of links that the visualizations will be restricted to.}

\item{plot}{The type of plot that should be returned Options are "heatmap", "cumsum", "bar" and "splitbar".}

\item{exclude_sm}{If TRUE, excludes the 'WhatsApp' system messages from the descriptive statistics. Default is FALSE.}
}
\value{
Plots and/or the subset data frame based on author names, datetime and emoji occurrence
}
\description{
Visualizes the occurrence of links in a 'WhatsApp' chatlog
}
\examples{
data <- readRDS(system.file("ParsedWhatsAppChat.rds", package = "WhatsR"))
plot_links(data)
}
