% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_chatlog.R
\name{create_chatlog}
\alias{create_chatlog}
\title{Creating test data in the structure of 'WhatsApp' chat logs}
\usage{
create_chatlog(
  n_messages = 150,
  n_chatters = 2,
  n_emoji = 50,
  n_diff_emoji = 20,
  n_links = 20,
  n_locations = 5,
  n_smilies = 20,
  n_diff_smilies = 15,
  n_media = 10,
  n_sdp = 3,
  startdate = "01.01.2019",
  enddate = "31.12.2022",
  language = "german",
  time_format = "24h",
  os = "android",
  path = getwd(),
  chatname = "Simulated_WhatsR_chatlog"
)
}
\arguments{
\item{n_messages}{Number of messages that are contained in the created .txt file.}

\item{n_chatters}{Number of different chatters present in the created .txt file.}

\item{n_emoji}{Number of messages that contain emoji. Must be smaller or equal to n_messages.}

\item{n_diff_emoji}{Number of different emoji that are used in the simulated chat.}

\item{n_links}{Number of messages that contain links. Must be smaller or equal to n_messages.}

\item{n_locations}{Number of messages that contain locations. Must be smaller or equal to n_messages.}

\item{n_smilies}{Number of messages that contain smilies. Must be smaller or equal to n_messages.}

\item{n_diff_smilies}{Number of different smilies that are used in the simulated chat.}

\item{n_media}{Number of messages that contain omitted media files. Must be smaller or equal to n_messages.}

\item{n_sdp}{Number of messages that contain self-deleting photos. Must be smaller or equal to n_messages.}

\item{startdate}{Earliest possible date for messages. Format is 'dd.mm.yyyy'. Timestamps for messages are created automatically between startdate and enddate. Input is interpreted as UTC}

\item{enddate}{Latest possible date for messages. Format is 'dd.mm.yyyy'. Timestamps for messages are created automatically between startdate and enddate. Input is interpreted as UTC}

\item{language}{Parameter for the language setting of the exporting phone. Influences structure of system messages}

\item{time_format}{Parameter for the time format setting of the exporting phone (am/pm vs. 24h). Influences the structure of timestamps.}

\item{os}{Parameter for the operating system setting of the exporting phone. Influences the structure of timestamps and 'WhatsApp' system messages.}

\item{path}{Character string for indicating the file path of where to save the file. Can be NA to not save a file. Default is getwd()}

\item{chatname}{Name for the created .txt file.}
}
\value{
A .txt file with a simulated 'WhatsApp' chat containing lorem ipsum but all structural properties of actual chats.
}
\description{
Creates a .txt file in the working directory that has the same structure as chat logs exported from 'WhatsApp'. Messages have a timestamp, sender name and message body
containing lorem ipsum, emoji, links, smilies, location, omitted media files, linebreaks, self-deleting photos, and 'WhatsApp' system messages. Timestamps are formatted according to specified phone operating system and
time format settings. 'WhatsApp' system messages are formatted according to specified phone operating system and language.
}
\examples{
SimulatedChat <- create_chatlog(path=NA)
}
