% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_emoji.R
\name{plot_emoji}
\alias{plot_emoji}
\title{Plotting emoji distributions in 'WhatsApp' chat logs}
\usage{
plot_emoji(
  data,
  names = "all",
  starttime = "1960-01-01 00:00",
  endtime = as.character(as.POSIXct(Sys.time(), tz = "UTC")),
  min_occur = 1,
  return_data = FALSE,
  emoji_vec = "all",
  plot = "bar",
  emoji_size = 10,
  font_family = "Noto Color Emoji",
  exclude_sm = FALSE
)
}
\arguments{
\item{data}{A 'WhatsApp' chat log that was parsed with \code{\link[WhatsR]{parse_chat}}.}

\item{names}{A vector of author names that the plots will be restricted to.}

\item{starttime}{Datetime that is used as the minimum boundary for exclusion. Is parsed with \code{\link[anytime]{anytime}}. Standard format is "yyyy-mm-dd hh:mm". Is interpreted as UTC to be compatible with 'WhatsApp' timestamps.}

\item{endtime}{Datetime that is used as the maximum boundary for exclusion. Is parsed with \code{\link[anytime]{anytime}}. Standard format is "yyyy-mm-dd hh:mm". Is interpreted as UTC to be compatible with 'WhatsApp' timestamps.}

\item{min_occur}{Minimum number of occurrences for emoji to be included in the plots. Default is 1.}

\item{return_data}{If TRUE, returns the subsetted data frame used for plotting. Default is FALSE.}

\item{emoji_vec}{A vector of emoji that the visualizations and data will be restricted to.}

\item{plot}{The type of plot that should be returned. Options are "heatmap", "cumsum", "bar" and "splitbar".}

\item{emoji_size}{Determines the size of the emoji displayed on top of the bars for "bar" and "splitbar", default is 10.}

\item{font_family}{Character string for indicating font family used to plot_emoji. Fonts might need to be installed manually, see \code{\link[extrafont]{font_import}}.}

\item{exclude_sm}{If TRUE, excludes the 'WhatsApp' system messages from the descriptive statistics. Default is FALSE.}
}
\value{
Plots and/or the subset data frame based on author names, datetime and emoji occurrence
}
\description{
Plots four different types of graphs for the emoji contained in a parsed 'WhatsApp' chat log. Returns dataframe used for plotting if desired.
}
\examples{
data <- readRDS(system.file("ParsedWhatsAppChat.rds", package = "WhatsR"))
plot_emoji(data,font_family="Times", exclude_sm = TRUE) #font_family = "Noto Color Emoji" on Linux
}
