% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{plot.XDNUTS}
\alias{plot.XDNUTS}
\title{Function to view the draws from the posterior distribution.}
\usage{
\method{plot}{XDNUTS}(
  x,
  type = 1,
  which = NULL,
  warm_up = FALSE,
  plot.new = FALSE,
  which_chains = NULL,
  colors = NULL,
  gg = TRUE,
  scale = 1,
  ...
)
}
\arguments{
\item{x}{an object of class \code{XDNUTS}.}

\item{type}{the type of plot to display. \describe{
\item{\code{type = 1}}{marginal chains, one for each desired dimension.}
\item{\code{type = 2}}{bivariate plot.}
\item{\code{type = 3}}{time series plot of the energy level sets. Good for a quick diagnostic of big models.}
\item{\code{type = 4}}{stickplot of the step-length of each iteration.}
\item{\code{type = 5}}{Histograms of the centered marginal energy in gray and of the first differences of energy in red.}
\item{\code{type = 6}}{Autoregressive function plot of the parameters.}
\item{\code{type = 7}}{Matplot of the empirical acceptance rate and refraction rates.}}}

\item{which}{either a numerical vector indicating the index of the parameters of interest or a string \describe{
\item{\code{which = 'continuous'}}{for plotting the first \eqn{d-k} parameters.}
\item{\code{which = 'discontinuous'}}{for plotting the last \eqn{k} parameters.}
}
where both \eqn{d} and \eqn{k} are elements contained in the output of the \link{xdnuts} function.
 If \code{type = 7}, it refers to the rates index instead. When \code{which = 'continuous'}, 
 only the global acceptance rate is displayed. In contrast, when \code{which = 'discontinuous'},
  the refraction rates are shown.}

\item{warm_up}{a boolean value indicating whether the plot should be made using the warm-up samples.}

\item{plot.new}{a boolean value indicating whether a new graphical window should be opened. This is advised if the parameters space is big.}

\item{which_chains}{a numerical vector indicating the index of the chains of interest.}

\item{colors}{a numerical vector containing the colors for each chain specified in \code{which_chains}
or for each rate specified in \code{which} when \code{type = 7}.}

\item{gg}{A boolean value indicating whether the plot should utilize the grammar of graphics features. 
Default value is set to \code{TRUE}.}

\item{scale}{A numeric value for scaling the appearance of plots.}

\item{...}{additional arguments to customize plots. In reality, these do nothing.}
}
\value{
A graphical object if \code{gg = TRUE}, otherwise nothing is returned.
}
\description{
Function to view the draws from the posterior distribution.
}
