% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xConverter.r
\name{xConverter}
\alias{xConverter}
\title{Function to convert an object between graph classes}
\usage{
xConverter(obj, from = c("dgCMatrix", "igraph"), to = c("igraph",
"dgCMatrix"), verbose = TRUE)
}
\arguments{
\item{obj}{an object of class "dgCMatrix" or "igraph"}

\item{from}{a character specifying the class converted from. It can be
one of "dgCMatrix" and "igraph"}

\item{to}{a character specifying the class converted to. It can be one
of "dgCMatrix" and "igraph"}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
an object of class "dgCMatrix" or "igraph"
}
\description{
\code{xConverter} is supposed to convert an object between classes
'dgCMatrix' and 'igraph'.
}
\note{
Conversion is also supported between classes 'dgCMatrix' and 'igraph'
}
\examples{
# generate a ring graph
g <- make_ring(10, directed=TRUE)

# convert the object from 'igraph' to 'dgCMatrix' class
xConverter(g, from='igraph', to='dgCMatrix')

\dontrun{
# Conversion between 'dgCMatrix' and 'igraph'
# ig.EF (an object of class "igraph" storing as a directed graph)
g <- xRDataLoader('ig.EF')
g

# convert the object from 'igraph' to 'dgCMatrix' class
s <- xConverter(g, from='igraph', to='dgCMatrix')
s[1:10,1:10]

# convert the object from 'dgCMatrix' to 'igraph' class
ig <- xConverter(s, from="dgCMatrix", to="igraph")
ig
}
}
\seealso{
\code{\link{xRDataLoader}}
}

