#############################################################################
#
# XLConnect
# Copyright (C) 2010 Mirai Solutions GmbH
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#############################################################################

#############################################################################
#
# XLConnect Constants
# 
# General Convention for Enumeration Types: XLC$"<ENUM_TYPE>.<VALUE>"
#
# Author: Martin Studer, Mirai Solutions GmbH
#
#############################################################################


# XLConnect Constants
XLC <- list()

# Error handling
XLC$"ERROR.WARN" <- "WARN"
XLC$"ERROR.STOP" <- "STOP"

# Data Type Constants (for method workbook.setDataFormat)
XLC$"DATA_TYPE.BOOLEAN" <- "BOOLEAN"
XLC$"DATA_TYPE.NUMERIC" <- "NUMERIC"
XLC$"DATA_TYPE.STRING" <- "STRING"
XLC$"DATA_TYPE.DATETIME" <- "DATETIME"


# Style Action Constants (for method workbook.setStyleAction)

XLC$"STYLE_ACTION.XLCONNECT" <- "XLCONNECT"
XLC$"STYLE_ACTION.NONE" <- "NONE"
XLC$"STYLE_ACTION.PREDEFINED" <- "PREDEFINED"
XLC$"STYLE_ACTION.NAME_PREFIX" <- "STYLE_NAME_PREFIX"
XLC$"STYLE_ACTION.DATA_FORMAT_ONLY" <- "DATA_FORMAT_ONLY"


# Border Constants (for methods cellstyle.setBorderXXX)

XLC$"BORDER.DASHED" <- 3
XLC$"BORDER.DASH_DOT" <- 9
XLC$"BORDER.DASH_DOT_DOT" <- 11
XLC$"BORDER.DOTTED" <- 7
XLC$"BORDER.DOUBLE" <- 6
XLC$"BORDER.HAIR" <- 4
XLC$"BORDER.MEDIUM" <- 2
XLC$"BORDER.MEDIUM_DASHED" <- 8
XLC$"BORDER.MEDIUM_DASH_DOT" <- 10
XLC$"BORDER.MEDIUM_DASH_DOT_DOT" <- 12
XLC$"BORDER.NONE" <- 0
XLC$"BORDER.SLANTED_DASH_DOT" <- 13
XLC$"BORDER.THICK" <- 5
XLC$"BORDER.THIN" <- 1


# Color Constants (from org.apache.poi.ss.usermodel.IndexedColors)
# Generated by:
# for(IndexedColors col : IndexedColors.values()) {
#	 System.out.println("XLC$\"COLOR." + col.toString() + "\" <- " + col.getIndex());
# }

XLC$"COLOR.BLACK" <- 8
XLC$"COLOR.WHITE" <- 9
XLC$"COLOR.RED" <- 10
XLC$"COLOR.BRIGHT_GREEN" <- 11
XLC$"COLOR.BLUE" <- 12
XLC$"COLOR.YELLOW" <- 13
XLC$"COLOR.PINK" <- 14
XLC$"COLOR.TURQUOISE" <- 15
XLC$"COLOR.DARK_RED" <- 16
XLC$"COLOR.GREEN" <- 17
XLC$"COLOR.DARK_BLUE" <- 18
XLC$"COLOR.DARK_YELLOW" <- 19
XLC$"COLOR.VIOLET" <- 20
XLC$"COLOR.TEAL" <- 21
XLC$"COLOR.GREY_25_PERCENT" <- 22
XLC$"COLOR.GREY_50_PERCENT" <- 23
XLC$"COLOR.CORNFLOWER_BLUE" <- 24
XLC$"COLOR.MAROON" <- 25
XLC$"COLOR.LEMON_CHIFFON" <- 26
XLC$"COLOR.ORCHID" <- 28
XLC$"COLOR.CORAL" <- 29
XLC$"COLOR.ROYAL_BLUE" <- 30
XLC$"COLOR.LIGHT_CORNFLOWER_BLUE" <- 31
XLC$"COLOR.SKY_BLUE" <- 40
XLC$"COLOR.LIGHT_TURQUOISE" <- 41
XLC$"COLOR.LIGHT_GREEN" <- 42
XLC$"COLOR.LIGHT_YELLOW" <- 43
XLC$"COLOR.PALE_BLUE" <- 44
XLC$"COLOR.ROSE" <- 45
XLC$"COLOR.LAVENDER" <- 46
XLC$"COLOR.TAN" <- 47
XLC$"COLOR.LIGHT_BLUE" <- 48
XLC$"COLOR.AQUA" <- 49
XLC$"COLOR.LIME" <- 50
XLC$"COLOR.GOLD" <- 51
XLC$"COLOR.LIGHT_ORANGE" <- 52
XLC$"COLOR.ORANGE" <- 53
XLC$"COLOR.BLUE_GREY" <- 54
XLC$"COLOR.GREY_40_PERCENT" <- 55
XLC$"COLOR.DARK_TEAL" <- 56
XLC$"COLOR.SEA_GREEN" <- 57
XLC$"COLOR.DARK_GREEN" <- 58
XLC$"COLOR.OLIVE_GREEN" <- 59
XLC$"COLOR.BROWN" <- 60
XLC$"COLOR.PLUM" <- 61
XLC$"COLOR.INDIGO" <- 62
XLC$"COLOR.GREY_80_PERCENT" <- 63
XLC$"COLOR.AUTOMATIC" <- 64


# Fill Constants (for method cellstyle.setFillPattern)
# Generated by:
# String[] values = new String[] {"NO_FILL", "SOLID_FOREGROUND", "FINE_DOTS", "ALT_BARS", "SPARSE_DOTS",
#	"THICK_HORZ_BANDS", "THICK_VERT_BANDS", "THICK_BACKWARD_DIAG", "THICK_FORWARD_DIAG", "BIG_SPOTS",
#	"BRICKS", "THIN_HORZ_BANDS", "THIN_VERT_BANDS", "THIN_BACKWARD_DIAG", "THIN_FORWARD_DIAG",
#	"SQUARES", "DIAMONDS"};
#
# Class c = Class.forName("org.apache.poi.ss.usermodel.CellStyle");
# for(String val : values) {
#	System.out.println("XLC$\"FILL." + val + "\" <- " + c.getField(val).get(null));
# }

XLC$"FILL.NO_FILL" <- 0
XLC$"FILL.SOLID_FOREGROUND" <- 1
XLC$"FILL.FINE_DOTS" <- 2
XLC$"FILL.ALT_BARS" <- 3
XLC$"FILL.SPARSE_DOTS" <- 4
XLC$"FILL.THICK_HORZ_BANDS" <- 5
XLC$"FILL.THICK_VERT_BANDS" <- 6
XLC$"FILL.THICK_BACKWARD_DIAG" <- 7
XLC$"FILL.THICK_FORWARD_DIAG" <- 8
XLC$"FILL.BIG_SPOTS" <- 9
XLC$"FILL.BRICKS" <- 10
XLC$"FILL.THIN_HORZ_BANDS" <- 11
XLC$"FILL.THIN_VERT_BANDS" <- 12
XLC$"FILL.THIN_BACKWARD_DIAG" <- 13
XLC$"FILL.THIN_FORWARD_DIAG" <- 14
XLC$"FILL.SQUARES" <- 15
XLC$"FILL.DIAMONDS" <- 16
