/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;

public class DateUtil {
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int SECONDS_PER_DAY = 86400;
    private static final int BAD_DATE = -1;
    private static final long DAY_MILLISECONDS = 86400000L;
    private static final Pattern TIME_SEPARATOR_PATTERN = Pattern.compile(":");
    private static final Pattern date_ptrn1 = Pattern.compile("^\\[\\$\\-.*?\\]");
    private static final Pattern date_ptrn2 = Pattern.compile("^\\[[a-zA-Z]+\\]");
    private static final Pattern date_ptrn3 = Pattern.compile("^[\\[\\]yYmMdDhHsS\\-/,. :\"\\\\]+0*[ampAMP/]*$");
    private static final Pattern date_ptrn4 = Pattern.compile("^\\[([hH]+|[mM]+|[sS]+)\\]");

    protected DateUtil() {
    }

    public static double getExcelDate(Date date) {
        return DateUtil.getExcelDate(date, false);
    }

    public static double getExcelDate(Date date, boolean use1904windowing) {
        GregorianCalendar calStart = new GregorianCalendar();
        calStart.setTime(date);
        return DateUtil.internalGetExcelDate(calStart, use1904windowing);
    }

    public static double getExcelDate(Calendar date, boolean use1904windowing) {
        return DateUtil.internalGetExcelDate((Calendar)date.clone(), use1904windowing);
    }

    private static double internalGetExcelDate(Calendar date, boolean use1904windowing) {
        if (!use1904windowing && date.get(1) < 1900 || use1904windowing && date.get(1) < 1904) {
            return -1.0;
        }
        double fraction = (double)(((date.get(11) * 60 + date.get(12)) * 60 + date.get(13)) * 1000 + date.get(14)) / 8.64E7;
        Calendar calStart = DateUtil.dayStart(date);
        double value = fraction + (double)DateUtil.absoluteDay(calStart, use1904windowing);
        if (!use1904windowing && value >= 60.0) {
            value += 1.0;
        } else if (use1904windowing) {
            value -= 1.0;
        }
        return value;
    }

    public static Date getJavaDate(double date) {
        return DateUtil.getJavaDate(date, false);
    }

    public static Date getJavaDate(double date, boolean use1904windowing) {
        if (!DateUtil.isValidExcelDate(date)) {
            return null;
        }
        int wholeDays = (int)Math.floor(date);
        int millisecondsInDay = (int)((date - (double)wholeDays) * 8.64E7 + 0.5);
        GregorianCalendar calendar = new GregorianCalendar();
        DateUtil.setCalendar(calendar, wholeDays, millisecondsInDay, use1904windowing);
        return calendar.getTime();
    }

    public static void setCalendar(Calendar calendar, int wholeDays, int millisecondsInDay, boolean use1904windowing) {
        int startYear = 1900;
        int dayAdjust = -1;
        if (use1904windowing) {
            startYear = 1904;
            dayAdjust = 1;
        } else if (wholeDays < 61) {
            dayAdjust = 0;
        }
        calendar.set(startYear, 0, wholeDays + dayAdjust, 0, 0, 0);
        calendar.set(14, millisecondsInDay);
    }

    public static boolean isADateFormat(int formatIndex, String formatString) {
        if (DateUtil.isInternalDateFormat(formatIndex)) {
            return true;
        }
        if (formatString == null || formatString.length() == 0) {
            return false;
        }
        String fs = formatString;
        StringBuilder sb = new StringBuilder(fs.length());
        block3: for (int i = 0; i < fs.length(); ++i) {
            char c = fs.charAt(i);
            if (i < fs.length() - 1) {
                char nc = fs.charAt(i + 1);
                if (c == '\\') {
                    switch (nc) {
                        case ' ': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case '\\': {
                            continue block3;
                        }
                    }
                } else if (c == ';' && nc == '@') {
                    ++i;
                    continue;
                }
            }
            sb.append(c);
        }
        fs = sb.toString();
        if (date_ptrn4.matcher(fs).matches()) {
            return true;
        }
        fs = date_ptrn1.matcher(fs).replaceAll("");
        if ((fs = date_ptrn2.matcher(fs).replaceAll("")).indexOf(59) > 0 && fs.indexOf(59) < fs.length() - 1) {
            fs = fs.substring(0, fs.indexOf(59));
        }
        return date_ptrn3.matcher(fs).matches();
    }

    public static boolean isInternalDateFormat(int format) {
        switch (format) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 45: 
            case 46: 
            case 47: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCellDateFormatted(Cell cell) {
        if (cell == null) {
            return false;
        }
        boolean bDate = false;
        double d = cell.getNumericCellValue();
        if (DateUtil.isValidExcelDate(d)) {
            CellStyle style = cell.getCellStyle();
            if (style == null) {
                return false;
            }
            short i = style.getDataFormat();
            String f = style.getDataFormatString();
            bDate = DateUtil.isADateFormat(i, f);
        }
        return bDate;
    }

    public static boolean isCellInternalDateFormatted(Cell cell) {
        if (cell == null) {
            return false;
        }
        boolean bDate = false;
        double d = cell.getNumericCellValue();
        if (DateUtil.isValidExcelDate(d)) {
            CellStyle style = cell.getCellStyle();
            short i = style.getDataFormat();
            bDate = DateUtil.isInternalDateFormat(i);
        }
        return bDate;
    }

    public static boolean isValidExcelDate(double value) {
        return value > -4.9E-324;
    }

    protected static int absoluteDay(Calendar cal, boolean use1904windowing) {
        return cal.get(6) + DateUtil.daysInPriorYears(cal.get(1), use1904windowing);
    }

    private static int daysInPriorYears(int yr, boolean use1904windowing) {
        if (!use1904windowing && yr < 1900 || use1904windowing && yr < 1900) {
            throw new IllegalArgumentException("'year' must be 1900 or greater");
        }
        int yr1 = yr - 1;
        int leapDays = yr1 / 4 - yr1 / 100 + yr1 / 400 - 460;
        return 365 * (yr - (use1904windowing ? 1904 : 1900)) + leapDays;
    }

    private static Calendar dayStart(Calendar cal) {
        cal.get(11);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.get(11);
        return cal;
    }

    public static double convertTime(String timeStr) {
        try {
            return DateUtil.convertTimeInternal(timeStr);
        }
        catch (FormatException e) {
            String msg = "Bad time format '" + timeStr + "' expected 'HH:MM' or 'HH:MM:SS' - " + e.getMessage();
            throw new IllegalArgumentException(msg);
        }
    }

    private static double convertTimeInternal(String timeStr) throws FormatException {
        String secStr;
        int len = timeStr.length();
        if (len < 4 || len > 8) {
            throw new FormatException("Bad length");
        }
        String[] parts = TIME_SEPARATOR_PATTERN.split(timeStr);
        switch (parts.length) {
            case 2: {
                secStr = "00";
                break;
            }
            case 3: {
                secStr = parts[2];
                break;
            }
            default: {
                throw new FormatException("Expected 2 or 3 fields but got (" + parts.length + ")");
            }
        }
        String hourStr = parts[0];
        String minStr = parts[1];
        int hours = DateUtil.parseInt(hourStr, "hour", 24);
        int minutes = DateUtil.parseInt(minStr, "minute", 60);
        int seconds = DateUtil.parseInt(secStr, "second", 60);
        double totalSeconds = seconds + (minutes + hours * 60) * 60;
        return totalSeconds / 86400.0;
    }

    public static Date parseYYYYMMDDDate(String dateStr) {
        try {
            return DateUtil.parseYYYYMMDDDateInternal(dateStr);
        }
        catch (FormatException e) {
            String msg = "Bad time format " + dateStr + " expected 'YYYY/MM/DD' - " + e.getMessage();
            throw new IllegalArgumentException(msg);
        }
    }

    private static Date parseYYYYMMDDDateInternal(String timeStr) throws FormatException {
        if (timeStr.length() != 10) {
            throw new FormatException("Bad length");
        }
        String yearStr = timeStr.substring(0, 4);
        String monthStr = timeStr.substring(5, 7);
        String dayStr = timeStr.substring(8, 10);
        int year = DateUtil.parseInt(yearStr, "year", Short.MIN_VALUE, Short.MAX_VALUE);
        int month = DateUtil.parseInt(monthStr, "month", 1, 12);
        int day = DateUtil.parseInt(dayStr, "day", 1, 31);
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, day, 0, 0, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private static int parseInt(String strVal, String fieldName, int rangeMax) throws FormatException {
        return DateUtil.parseInt(strVal, fieldName, 0, rangeMax - 1);
    }

    private static int parseInt(String strVal, String fieldName, int lowerLimit, int upperLimit) throws FormatException {
        int result;
        try {
            result = Integer.parseInt(strVal);
        }
        catch (NumberFormatException e) {
            throw new FormatException("Bad int format '" + strVal + "' for " + fieldName + " field");
        }
        if (result < lowerLimit || result > upperLimit) {
            throw new FormatException(fieldName + " value (" + result + ") is outside the allowable range(0.." + upperLimit + ")");
        }
        return result;
    }

    private static final class FormatException
    extends Exception {
        public FormatException(String msg) {
            super(msg);
        }
    }
}

