\name{dzim}
\alias{dzim}
\title{Fitting Dynamic Zero-Inflated Models}
\usage{
dzim(formula, data, subset, na.action, weights = 1, offset = 0,
  control = dzim.control(...), ...)
}
\arguments{
  \item{formula}{an objective of class
  "\code{\link{formula}}".}

  \item{data}{an optional dataframe, list or environment
  containing the variables in the model.}

  \item{subset}{an optional vector specifying a subset of
  observations to be used in the fitting process.}

  \item{na.action}{a function which indicates what should
  happen when the data contain \code{NA}s.}

  \item{weights}{an optional vector of 'prior weights' to
  be used in the fitting process.}

  \item{offset}{this can be used to specify a priori known
  component to be included in the linear predictor during
  fitting.}

  \item{control}{control arguments from
  \code{\link{dzim.control}}}

  \item{...}{additional arguments}
}
\description{
\code{dzim} is used to fit dynamic zero-inflated models.
}
\seealso{
\code{\link{dzim.fit}}, \code{\link{dzim.filter}},
\code{\link{dzim.smooth}}, \code{\link{dzim.control}},
\code{\link{dzim.sim}}, \code{\link{dzim.plot}}
}
\keyword{regression}

