% Generated by roxygen2 (4.0.1): do not edit by hand
\name{dzim.control}
\alias{dzim.control}
\title{Auxiliary for Controlling DZIM Fitting}
\usage{
dzim.control(dist = c("poisson", "nb", "zip", "zinb"), trace = FALSE,
  start = NULL, order = 1, mu0 = rep(0, order), Sigma0 = diag(1, order),
  N = 1000, R = 1000, niter = 500)
}
\arguments{
\item{dist}{count model family}

\item{trace}{logical; if TRUE, display iteration history.}

\item{start}{initial parameter values.}

\item{order}{autoregressive order.}

\item{mu0}{mean vector for initial state.}

\item{Sigma0}{covariance matrix for initial state.}

\item{N}{number of particiles in particle filtering.}

\item{R}{number of replications in particle smoothing.}

\item{niter}{number of iterations.}
}
\description{
Auxiliary function for \code{\link{dzim}} fitting. Typically only used internally by
\code{\link{dzim.fit}}, but may be used to construct a control argument for either function.
}
\note{
The default values of \code{N}, \code{R}, and \code{niter} are chosen based on our experience.
In some cases, \code{N} = 500, \code{R} = 500, and \code{niter} = 200 might be sufficient.
The \code{\link{dzim.plot}} function should always be used for convergence diagnostics.
}
\seealso{
\code{\link{dzim}},
\code{\link{dzim.fit}},
\code{\link{dzim.filter}},
\code{\link{dzim.smooth}},
\code{\link{dzim.sim}},
\code{\link{dzim.plot}}
}
\keyword{regression}

