% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZIPG_main.R
\name{ZIPG_main}
\alias{ZIPG_main}
\title{Fit zero-inflated poisson-gamma model via EM Algorithm}
\usage{
ZIPG_main(
  data,
  W,
  M,
  X,
  X_star,
  return_model = TRUE,
  pbWald_list = NULL,
  bWald_list = NULL
)
}
\arguments{
\item{data}{Data.frame for covariates of interest}

\item{W}{Count data}

\item{M}{Sequencing depth, ZIPG use log(M) as offset by default}

\item{X}{Formula of covariates of differential abundance}

\item{X_star}{Formula of covariates of differential varibility}

\item{return_model}{whether return full complete imfomation for fitted model}

\item{pbWald_list}{A list of arguments for parameteric bootstrap Wald test,
B for bootstrap sample size, X0 and X_star0 for formula of covariates included in H0}

\item{bWald_list}{A list of arguments for non-parameteric bootstrap Wald test, B for bootstrap sample size,}
}
\value{
A list of ZIPG fitted model. Use ZIPG_summary() for a quick look at the results.
}
\description{
Fit zero-inflated poisson-gamma model via EM Algorithm
}
\examples{
data(Dietary)
dat = Dietary
ZIPG_res <- ZIPG_main(data = dat$COV,
X = ~ALC01+nutrPC1+nutrPC2, X_star = ~ ALC01,
W = dat$OTU[,100], M = dat$M )
ZIPG_summary(ZIPG_res)
}
