% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMMZOIP.R
\name{RMM.ZOIP}
\alias{RMM.ZOIP}
\title{ZOIP regression with mixed efects}
\usage{
RMM.ZOIP(formula.mu, formula.sigma = ~1, formula.p0 = ~1, formula.p1 = ~1,
  data, formula.random, link = c("identity", "identity", "identity",
  "identity"), family = "R-S", optimizer = "nlminb", n.points = 11,
  pruning = TRUE)
}
\arguments{
\item{formula.mu}{Formula that defines the regression function for mu, p.e and ~ x1 + x2, it is necessary to define the response variable.}

\item{formula.sigma}{Formula that defines the regression function for the sigma parameter, a possible value is ~ x1, by default ~ 1.}

\item{formula.p0}{Formula that defines the regression function for p0, a possible value is ~ x1, by default ~ 1.}

\item{formula.p1}{Formula that defines the regression function for p1, a possible value is ~ x1, by default ~ 1.}

\item{data}{It is the data set in data.frame format where it must contain the names of the columns as they are in the formulas.}

\item{formula.random}{Formula that defines the mixed effect within the model, it should be only the random intercept that will be taken into account in the parameter of the mean and the dispersion, the admissible structure is the following formula.random = ~ 1 | G1, where G1 is the variable that indicates the groups or subjects in the model, should always be defined.}

\item{link}{It is a vector with the appropriate link functions for each parameter to be estimated according to the options chosen in the family and formula parameters. If the regression model does not have covariables, the identity option should be used as a link function, regardless of the value chosen in the family, possible options are logit, log, default link = c ('identity', 'identity', 'identity', 'identity').}

\item{family}{choice of the parameterization or distribution, family = 'R-S' parameterization beta distribution Rigby and Stasinopoulos, 'F-C' distribution Beta parametrization Ferrari and Cribari-Neto, 'Original' Beta distribution classic parameterization, 'Simplex' simplex distribution.}

\item{optimizer}{Choice of the optimizer, used to find the convergence of the maximum likelihood. you can choose the value of 'nlminb' or 'optim', by default 'nlminb'.}

\item{n.points}{Number of points to use in the approximation of the likelihood function by means of quadrature Gauss-Hermite adaptive multidimensional, by default is 11, it is recommended not to give a very large value to this parameter, because it will significantly affect the times of convergence of the model.}

\item{pruning}{It is a Boolean value that indicates if pruning is used or not, for the quadrature of multidimensional Adaptive Gauss-Hermite, by default it is TRUE.}
}
\description{
function RMM.ZOIP fits a mixed ZOIP regression model with random intercepts
normals in the mean and dispersion parameter, the estimation is done via maximum likelihood
and the gauss-hermite adaptive quadrangle with or without pruning. the model may or may not include effects
fixed in any of its parameters, just as it can be a bilaterally inflated model, unilaterally or without parameters
inflated.
}
\examples{

library(ZOIP)

N<-2
ni<-10
set.seed(12345)
Ciudad <- rep(1:N, each=ni)
Total_mora<-rexp(N*ni,rate=1)
set.seed(12345)
b0i <- rep(rnorm(n=N,sd=0.5), each=ni)
set.seed(12345)
b1i <- rep(rnorm(n=N,sd=0.4), each=ni)

neta <- (-1.13+b0i)+0.33*Total_mora
neta2<-(0.33+b1i)+0.14*Total_mora

mu <- 1 / (1 + exp(-neta))
sigma <- 1 / (1 + exp(-neta2))

p0 <- 0.05
p1 <- 0.05

mu[mu==1] <- 0.999
mu[mu==0] <- 0.001

sigma[sigma==1] <- 0.999
sigma[sigma==0] <- 0.001
family<-'R-S'
set.seed(12345)
Y <- rZOIP(n=length(mu), mu = mu, sigma = sigma ,p0=p0,p1=p1,family=family)

data_sim<-data.frame(Y,Total_mora,Ciudad)

n.points <- 3
pruning <- TRUE

formula.mu=Y~Total_mora
formula.sigma=~Total_mora
formula.p0=~1
formula.p1=~1
formula.random= ~ 1 | Ciudad
link=c('logit','logit','identity','identity')
optimizer<-'nlminb'
\donttest{
mod<-RMM.ZOIP(formula.mu=formula.mu,formula.sigma=formula.sigma,formula.p0=formula.p0,
               formula.p1=formula.p1,data=data_sim,formula.random=formula.random,link=link,
               family=family,optimizer=optimizer,n.points=n.points,pruning=pruning)
mod
}

}
