\name{maize.model}
\alias{maize.model}
\title{The basic Maize model function}
\usage{
  maize.model(Tbase, RUE, K, alpha, LAImax, TTM, TTL,
    weather, sdate, ldate)
}
\arguments{
  \item{Tbase}{: parameter the baseline temperature for
  growth (degreeCelsius)}

  \item{TTM}{: parameter temperature sum for crop maturity
  (degreeC.day)}

  \item{TTL}{: parameter temperature sum at the end of leaf
  area increase (degreeC.day)}

  \item{K}{: parameter extinction coefficient (relation
  between leaf area index and intercepted radiation) (-)}

  \item{RUE}{: parameter radiation use efficiency (?)}

  \item{alpha}{: parameter the relative rate of leaf area
  index increase for small values of leaf area index (?)}

  \item{LAImax}{: parameter maximum leaf area index (-)}

  \item{weather}{: weather data.frame for one single year}

  \item{sdate}{: sowing date}

  \item{ldate}{: last date}
}
\value{
  data.frame with daily TT, LAI,B
}
\description{
  \strong{Model description.} This model is a dynamic model
  of crop growth for Maize cultivated in potential
  conditions. The crop growth is represented by three state
  variables, leaf area per unit ground area (leaf area
  index, LAI), total biomass (B) and cumulative thermal
  time since plant emergence (TT). It is based on key
  concepts included in most crop models, at least for the
  "potential production" part. In fact, this model does not
  take into account any effects of soil water, nutrients,
  pests, or diseases,...
}
\details{
  The tree state variables are dynamic variables depending
  on days after emergence: TT(day), B(day), and LAI(day).
  The model has a time step dt of one day.\cr The model is
  defined by a few equations, with a total of seven
  parameters for the described process. \cr (1)
  \eqn{TT(day+1) = TT(day)+dTT(day)}{TT(day+1) =
  TT(day)+dTT(day)} \cr (2) \eqn{B(day+1) =
  B(day)+dB(day)}{B(day+1) = B(day)+dB(day)} \cr (3)
  \eqn{LAI(day+1) = LAI(day)+dLAI(day)}{LAI(day+1) =
  LAI(day)+dLAI(day)} \cr (4) \eqn{dTT(day) =
  \max(\frac{TMIN(day)+TMAX(day)}{2}-Tbase;0)}{dTT(day) =
  max((TMIN(day)+TMAX(day))/2-Tbase ; 0)} \cr (5)
  \eqn{dB(day) = RUE*(1-e^{-K*LAI(day)*I(day)}),\ if\
  TT(day)\le TTM}{dB(day) = RUE*(1-e^{-K*LAI(day)*I(day)}),
  if TT(day)<= TTM} \cr \eqn{dB(day) = 0,\ if\
  TT(day)>TTM}{dB(day) = 0, if TT(day)>TTM} \cr (6)
  \eqn{dLAI(day) =
  alpha*dTT(day)*LAI(day)*\max(LAImax-LAI(day);0),\ if \
  TT(day)\le TTL
  }{alpha*dTT(day)*LAI(day)*max(LAImax-LAI(day);0), if
  TT(day)<= TTL } \cr \eqn{dLAI(day) = 0,\ if\ TT(day)>TTL
  }{dLAI(day) = 0 if TT(day)>TTL}
}
\examples{
weather = maize.weather(working.year=2010, working.site=30,weather_all=weather_EuropeEU)
maize.model(Tbase=7, RUE=1.85, K=0.7, alpha=0.00243, LAImax=7, TTM=1200, TTL=700, weather, sdate=100, ldate=250)
}

