% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Evil.R
\name{Evil}
\alias{Evil}
\alias{A001969}
\title{Evil numbers}
\usage{
Evil(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A001969}{A001969}, an \emph{Evil} number has an even number of 1's in its binary expansion.
First 6 Evil numbers are  	0, 3, 5, 6, 9, 10.
}
\examples{
## generate first 20 Evil numbers
first20 = Evil(20)

## print without trailing 0's.
print(first20, drop0trailing = TRUE)

}
\seealso{
\code{\link{Odious}}
}
