% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Factorial.R
\name{Factorial}
\alias{Factorial}
\alias{A000142}
\title{Factorial numbers}
\usage{
Factorial(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A000142}{A000142}, a \emph{Factorial} is the product of all positive integers smaller than or equal to the number.
First 6 such numbers are   	1, 1, 2, 6, 24, 120
}
\examples{
## generate first 10 Factorials
first10 = Factorial(10)

## print without trailing 0's.
print(first10, drop0trailing = TRUE)

}
