% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Palindromic.R
\name{Palindromic}
\alias{Palindromic}
\alias{A002113}
\title{Palindromic numbers}
\usage{
Palindromic(n, base = 10, gmp = TRUE)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{base}{choice of base.}

\item{gmp}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A002113}{A002113}, a \emph{Palindromic} number is a number that
remains the same when its digits are reversed. First 6 Palindromic numbers in decimal are 0, 1, 2, 3, 4, 5.
This function supports various base by specifying the parameter \code{base} but returns are still represented in decimal.
}
\examples{
## generate first 30 palindromic number in decimal
print(Palindromic(30))

}
