% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_tiles.R
\name{canvas_tiles}
\alias{canvas_tiles}
\title{Draw Portuguese Tiles}
\usage{
canvas_tiles(
  colors,
  background = "#ffffff",
  iterations = 1000,
  size = 5,
  col.line = "#000000",
  resolution = 100,
  layout = NULL
)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork, or a list containing a set of colors for each unique tile on the wall.}

\item{background}{a character specifying the color of the background.}

\item{iterations}{a positive integer specifying the number of iterations of the algorithm.}

\item{size}{a positive integer specifying how many tiles should be in each row of the wall.}

\item{col.line}{a character specifying the color of the joints between the tiles.}

\item{resolution}{resolution of the artwork in pixels per row/column. Increasing the resolution increases the quality of the artwork but also increases the computation time exponentially.}

\item{layout}{optional. A matrix containing integers ranging from 1 to the maximum number of unique tiles (i.e., \code{length(colors)}) specifying the placement of the tiles on the wall.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function uses a reaction diffusion algorithm in an attempt to draw a Portuguese-styled tiling pattern.
}
\examples{
\donttest{
set.seed(3)

# Simple example
canvas_tiles(colors = colorPalette("azul"), iterations = 5000)

# Advanced example
canvas_tiles(colors = list(
  colorPalette("blossom"),
  colorPalette("neon1"),
  colorPalette("dark1")
))

# Custom layout
layout <- matrix(c(
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1,
  1, 1, 2, 2, 2, 1, 2, 2, 2, 1, 1,
  1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1,
  1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1,
  1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1,
  1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
), nrow = 11, byrow = TRUE)
canvas_tiles(
  colors = list(colorPalette("azul"), colorPalette("blossom")),
  size = nrow(layout), layout = layout
)

# Another custom layout
set.seed(11)
layout <- matrix(c(
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 1, 2, 2, 3, 3, 2, 2, 4, 4, 4, 2, 5, 5, 5, 2, 6, 2, 6, 2,
  2, 1, 2, 1, 2, 3, 2, 3, 2, 2, 4, 2, 2, 5, 2, 2, 2, 6, 2, 6, 2,
  2, 1, 1, 1, 2, 3, 3, 2, 2, 2, 4, 2, 2, 2, 5, 2, 2, 2, 6, 2, 2,
  2, 1, 2, 1, 2, 3, 2, 3, 2, 2, 4, 2, 5, 5, 5, 2, 2, 2, 6, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
), nrow = 21, byrow = TRUE)
canvas_tiles(
  colors = list(
    colorPalette("blossom"),
    colorPalette("azul"),
    colorPalette("neon1"),
    colorPalette("mixer4"),
    colorPalette("neon2"),
    colorPalette("vrolik1"),
    colorPalette("blackwhite")
  ),
  iterations = 2000,
  size = nrow(layout), layout = layout
)
}

}
\references{
\url{https://en.wikipedia.org/wiki/Reaction–diffusion_system}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
