% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPmat.r
\name{plotPmat}
\alias{plotPmat}
\title{Image plot of P-value matrix.}
\usage{
plotPmat(Ps, zlim = NULL, main = NULL, yt = NULL, xlab = "SNPs",
  thresh = -log(5e-08, 10), trait.names = NULL)
}
\arguments{
\item{Ps}{P-value matrix. Row represent traits, column represent SNPs}

\item{zlim}{-log 10 transformed p value range.}

\item{main}{main title.}

\item{yt}{it controls the location of trait names.}

\item{xlab}{lable for x axis. Default is "SNPs".}

\item{thresh}{Default is set to widely used genome wise threshold -log(5e-8,10).}

\item{trait.names}{A vector of trait names.}
}
\value{
Image of P-values matrix.
}
\description{
It gives a P-value image for a given P-value matrix.
}
\examples{
## Say we have 3 traits and their p-values at 5 SNPs. 
Ps <- rbind( c(0.001, 0.4, 0.5, 0.00000001, .1),
           c(0.03, 0.3, 0.3, 0.00001, .2),
           c(0.01, 0.2, 0.4, 0.001, .0001) )

## We can visualize it using plotPmat function.
plotPmat(Ps)


}
\references{
Gene- and pathway-based association tests for multiple traits with GWAS summary statistics (2016) Kwak I-Y, Pan W., Bioinformatics.
}
\seealso{
\code{\link{aSPUs}}
}
\author{
Il-Youp Kwak and Wei Pan
}
