% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aSPUs.R
\name{aSPUs}
\alias{aSPUs}
\title{Sum of Powered Score (SPUs) tests and adaptive SPU (aSPUs) test for single trait - SNP set association with GWAS summary statistics.}
\usage{
aSPUs(Zs, corSNP, pow = c(1:8, Inf), n.perm = 1000, Ps = FALSE, prune = TRUE)
}
\arguments{
\item{Zs}{Z-scores for each SNPs. It could be P-values if the Ps option is TRUE.}

\item{corSNP}{Correlation matirx of the SNPs to be tested; estimated from a
reference panel (based on the same set of the reference alleles as
used in calculating Z-scores).}

\item{pow}{power used in SPU test. A vector of the powers.}

\item{n.perm}{number of permutations or bootstraps.}

\item{Ps}{TRUE if input is p-value, FALSE if input is Z-scores. The default is FALSE.}

\item{prune}{if it is TRUE, do pruing before the test using pruneSNP function.}
}
\value{
A list object, Ts : test statistics for the SPU tests (in the order of the specified pow) and finally for the aSPU test.
        pvs : p-values for the SPUs and aSPUs tests.
}
\description{
It gives p-values of the SPUs tests and aSPUs test with GWAS summary statistics.
}
\examples{

data(kegg9)
## example analysis using aSPUM test.
g <- kegg9$gene.info[1,1]  #  SOAT1 
## Take snps mapped on gene "SOAT1" from the information of gene.info and snp.info. 
snps <- which( ( kegg9$snp.info[,2] == kegg9$gene.info[kegg9$gene.info[,1] == g, 2] ) &
                 (kegg9$snp.info[,3] > kegg9$gene.info[kegg9$gene.info[,1] == g, 3] ) &
                 (kegg9$snp.info[,3] < kegg9$gene.info[kegg9$gene.info[,1] == g, 4] )  )
## Take subsets
newP <- kegg9$nP[snps] ;
ldsub <- kegg9$ldmatrix[snps, snps];

## Get p-value for gene SOAT1. Read vignette for details.
out <- aSPUs(newP, corSNP=ldsub , pow=c(1:8, Inf), n.perm=100, Ps=TRUE)

out$Ts
# This is a vector of Test Statistics for SPUM and aSPUM tests.
# SPUs1 to SPUsInf corresponds with the option pow=c(1:8, Inf)
# They are SPUs test statistics.
# The last element aSPUs is minimum of them, aSPUs statistic.

out$pvs
# This is a vector of p-values for SPUs and aSPUs tests.
# SPUs1 to SPUsInf corresponds with the option pow=c(1:8, Inf)
# They are p-values for corresponding SPUs tests.
# The last element is p-value of aSPUs test.

}
\references{
Il-Youp Kwak, Wei Pan (2015)
Adaptive Gene- and Pathway-Trait Association Testing with GWAS Summary Statistics,
Bioinformatics, 32(8), 1178-1184.
}
\seealso{
\code{\link{aSPUw}} \code{\link{aSPU}} \code{\link{aSPUsPath}}
}
\author{
Il-Youp Kwak and Wei Pan
}
