% Generated by roxygen2 (4.0.2): do not edit by hand
\name{adf.test}
\alias{adf.test}
\title{Augmented Dickey-Fuller Test}
\usage{
adf.test(x, nlag = NULL, output = TRUE)
}
\arguments{
\item{x}{a numeric vector or univariate time series.}

\item{nlag}{the lag order with default to calculate the test statistic. See details for
the default.}

\item{output}{a logical value indicating to print the test results in R console.
The default is \code{TRUE}.}
}
\value{
A list containing the following components:
   \item{type1}{a matrix with three columns: \code{lag}, \code{ADF}, \code{p.value},
   where \code{ADF} is the Augmented Dickey-Fuller test statistic.}
   \item{type2}{same as above for the second type of linear model.}
   \item{type3}{same as above for the third type of linear model.}
}
\description{
Performs the Augmented Dickey-Fuller test for the null hypothesis
of a unit root of a univarate time series \code{x} (equivalently, \code{x} is a
non-stationary time series).
}
\details{
The Augmented Dickey-Fuller test incorporates
three types of linear regression models. The first type (\code{type1}) is a linear model
with no drift and linear trend with respect to time:
\deqn{dx[t] = \rho*x[t-1] + \beta[1]*dx[t-1] + ... + \beta[nlag - 1]*dx[t - nlag + 1]
+e[t],}
where \eqn{d} is an operator of first order difference, i.e.,
\eqn{dx[t] = x[t] - x[t-1]}, and \eqn{e[t]} is an error term.

The second type (\code{type2}) is a linear model with drift but no linear trend:
\deqn{dx[t] = \mu  + \rho*x[t-1] + \beta[1]*dx[t-1] + ... +
\beta[nlag - 1]*dx[t - nlag + 1] +e[t].}

The third type (\code{type3}) is a linear model with both drift and linear trend:
\deqn{dx[t] = \mu + \beta*t + \rho*x[t-1] + \beta[1]*dx[t-1] + ... +
\beta[nlag - 1]*dx[t - nlag + 1] +e[t].}

We use the default \code{nlag = floor(4*(length(x)/100)^(2/9))} to
calcuate the test statistic.
The Augmented Dickey-Fuller test statistic is defined as
\deqn{ADF = \rho.hat/S.E(\rho.hat),}
where \eqn{\rho.hat} is the coefficient estimation
and \eqn{S.E(\rho.hat)} is its corresponding estimation of standard error for each
type of linear model. The p.value is
calculated by interpolating the test statistics from the corresponding critical values
tables (see Table 10.A.2 in Fuller (1996)) for each type of linear models with given
sample size \eqn{n} = length(\code{x}).
The Dickey-Fuller test is a special case of Augmented Dickey-Fuller test
when \code{nlag} = 2.
}
\note{
Missing values are removed.
}
\examples{
# ADF test for AR(1) process
x <- arima.sim(list(order = c(1,0,0),ar = 0.2),n = 100)
adf.test(x)
# ADF test for co2 data
adf.test(co2)
}
\author{
Debin Qiu
}
\references{
Fuller, W. A. (1996). Introduction to Statistical Time Series, second ed., New York:
 John Wiley and Sons.
}
\seealso{
\code{\link{pp.test}}, \code{\link{kpss.test}}, \code{\link{stationary.test}}
}

