% Generated by roxygen2 (4.0.2): do not edit by hand
\name{forecast}
\alias{forecast}
\title{Forecast From ARIMA Fits}
\usage{
forecast(object, lead = 1, id = NULL, alpha = 0.05, output = TRUE)
}
\arguments{
\item{object}{the result of an \code{arima} or \code{estimate} fit.}

\item{lead}{the number of steps ahead for which prediction is required. The default is
\code{1}.}

\item{id}{the id of the observation which is the time. The default is \code{NULL}.}

\item{alpha}{the significant level for constructing the confidence interval of prediction.
The default is \code{0.05}.}

\item{output}{a logical value indicating to print the results in R console.
The default is \code{TRUE}.}
}
\value{
A matrix with \code{lead} rows and five columns. Each column represents the number
of steps ahead (\code{Lead}), the predicted values (\code{Forecast}), the standard errors
(\code{S.E}) and the 100*(1 - \eqn{\alpha})\% lower bound (\code{Lower}) and upper bound
(\code{Upper}) of confidence interval.
}
\description{
Forecasts from models fitted by \code{\link{arima}} or \code{\link{estimate}}
function.
}
\details{
This function is originally from \code{\link{predict.Arima}} in \code{stats} package,
but has a nice output
including 100*(1 - \eqn{\alpha})\% confidence interval and a prediction plot. It is
similar to FORECAST statement in PROC ARIMA of SAS.
}
\examples{
x <- arima.sim(list(order = c(3,0,0),ar = c(0.2,0.4,-0.15)),n = 100)
fit <- estimate(x,p = 3) # same as fit <- arima(x,order = c(3,0,0))
forecast(fit,lead = 4)

# forecast with id
t <- as.Date("2014-03-25") + 1:100
forecast(fit,lead = 4, id = t)
}
\author{
Debin Qiu
}
\seealso{
\code{\link{predict.Arima}}
}

