% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPropChange.R
\name{getPropChange}
\alias{getPropChange}
\title{Get wild type and substituted amino acid properties and associated property changes}
\usage{
getPropChange(subFile, propertyDF = "Cruciani", propertyIndex = 1)
}
\arguments{
\item{subFile}{A data frame of single or multiple substitutions obtained using 'getAASub' function}

\item{propertyDF}{Choose one of Cruciani, Fasgai, Kidera or AAindex based amino acid properties}

\item{propertyIndex}{The amino acid property to analyse. It is row number in propertyDF data frame}
}
\value{
A substitution data frame with three additional columns i.e. wt.Prop, mu.Prop and Delta.Prop
}
\description{
Get wild type and substituted amino acid properties and associated property changes
}
\examples{
ssFileLoc <- system.file("extdata", "singleSub.rda", package = "aaSEA")
singleSubFile <- readRDS(ssFileLoc)
msFileLoc <- system.file("extdata", "multiSub.rda", package = "aaSEA")
multiSubFile <- readRDS(msFileLoc)
getPropChange(subFile = singleSubFile, propertyDF = "Cruciani", propertyIndex = 1)
getPropChange(subFile = multiSubFile, propertyDF = "Cruciani", propertyIndex = 1)
}
