% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_external.R
\name{everyone}
\alias{everyone}
\title{Use all data rows as a group in an aba model.}
\usage{
everyone()
}
\value{
This function actually just returns a value of TRUE.
}
\description{
This is a helper function which allows you to specify a group in an aba model
that does not have any filtering conditions. This is useful when you want
to specify an aba model with one sub-group of the data but also want to
fit models on the entire data. This function is really only necessary to be
used instead of a call to \code{set_groups} when building an aba model.
}
\examples{

data <- adnimerge \%>\% dplyr::filter(VISCODE == 'bl')

# fit model with one subgroup (DX_bl) and also the entire data
model <- data \%>\% aba_model() \%>\%
  set_groups(
    everyone(),
    DX_bl \%in\% c('MCI', 'AD')
  ) \%>\%
  set_outcomes(ConvertedToAlzheimers, CSF_ABETA_STATUS_bl) \%>\%
  set_predictors(PLASMA_ABETA_bl, PLASMA_PTAU181_bl, PLASMA_NFL_bl) \%>\%
  set_stats(
    stat_glm(std.beta = TRUE)
  ) \%>\%
  fit()

model_summary <- model \%>\% aba_summary()

}
