% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc_mcmc.R
\name{abcMCMC}
\alias{abcMCMC}
\title{ABC-MCMC for load duration experiment data}
\usage{
abcMCMC(n, numBurning, numThining, inputD, dataNames, verbose = FALSE)
}
\arguments{
\item{n}{number of posterior samples}

\item{numBurning}{number of burn-in iterations}

\item{numThining}{number of thining iterations}

\item{inputD}{bandwidth \eqn{\delta} for ABC approximation}

\item{dataNames}{a vector of strings of the names of the datasets, which
must be in the format "ID_(\eqn{\tau_c})_(t_c)Y" (see Details and Example)}

\item{verbose}{displays information messages to console if TRUE}
}
\value{
Returns a matrix of posterior samples where each row is one \eqn{\theta}, and if verbose is TRUE, prints the acceptance rate.
}
\description{
Use modified ABC-MCMC algorithm to obtain posterior samples of
\eqn{\theta = (\mu_a, \sigma_a, \mu_b, \sigma_b, \mu_c, \sigma_c, \mu_n, \sigma_n, \mu_{\sigma_0} , \sigma_{\sigma_0})}{\theta = (\mu_a, \sigma_a, \mu_b, \sigma_b, \mu_c, \sigma_c, \mu_n, \sigma_n, \mu_\sigma0 , \sigma_\sigma0)},
given ramp and constant load failure time data.
}
\details{
The generated posterior samples are the parameters associated with (a, b, c, n, \eqn{\eta}), which are the
random effects in the Canadian Model for load duration,
\deqn{\frac{d}{dt} \alpha(t) = [(a\tau_s)(\tau(t)/\tau_s - \sigma_0)_+]^b + [(c\tau_s)(\tau(t)/\tau_s - \sigma_0)_+]^n\alpha(t),}{d/dt \alpha(t) = [(a * \tau_s) * (\tau(t) / \tau_s - \sigma_0)_+]^b + [(c * \tau_s) * (\tau(t) / \tau_s - \sigma_0)_+]^n * \alpha(t),}
where

      - \eqn{a|\mu_a, \sigma_a \sim Log-Normal(\mu_a, \sigma_a)}{a|\mu_a, \sigma_a ~ Log-Normal(\mu_a, \sigma_a)};

      - \eqn{b|\mu_b, \sigma_b \sim Log-Normal(\mu_b, \sigma_b)}{b|\mu_b, \sigma_b ~ Log-Normal(\mu_b, \sigma_b)};

      - \eqn{c|\mu_c, \sigma_c \sim Log-Normal(\mu_c, \sigma_c)}{c|\mu_c, \sigma_c ~ Log-Normal(\mu_c, \sigma_c)};

      - \eqn{n|\mu_n, \sigma_n \sim Log-Normal(\mu_n, \sigma_n)}{n|\mu_n, \sigma_n ~ Log-Normal(\mu_n, \sigma_n)};

      - \eqn{\eta|\mu_{\sigma_0}, \sigma_{\sigma_0} \sim Log-Normal(\mu_{\sigma_0}, \sigma_{\sigma_0})}{\eta|\mu_\sigma0, \sigma_\sigma0 ~ Log-Normal(\mu_\sigma0, \sigma_\sigma0)} and set \eqn{\sigma_0 = \frac{\eta}{1+\eta}}{\sigma_0 = \eta / (1 + \eta)}.

* \eqn{(x)_+ = max(x, 0)}.

* \eqn{\sigma_0} serves as the stress ratio threshold in that damage starts to accumulate only when \eqn{\tau(t)/\tau_s > \sigma_0}.

* When sample pieces are subject to the load profile

\eqn{\tau(t) = kt} if \eqn{t \le T_0}{t <= T_0}

\eqn{\tau(t) = \tau_c} if \eqn{t > T_0}

where \eqn{\tau_c} is the selected constant-load level under the ramp-loading rate k, and \eqn{T_0} is the
time required for the load to reach \eqn{\tau_c} under the ramp-loading rate k.

 * The constant load level is assumed to be reached at the ramp-loading rate (k). The ramp-loading rate is 388,440 psi/hour.

 * The constant load test ends at time \eqn{t_c} (in years).

 * To achieve a ramp-load test, set \eqn{\tau_c} to \code{Inf}.
}
\examples{
# run the abc-mcmc algorithm to obtain 10 posterior samples
# example only, more iterations needed for convergence
resTheta = abcMCMC(10, 100, 10, 0.3, c("constLoad_4500_1Y"), TRUE)


}
\references{
Foschi, R. O., Folz, B., and Yao, F. (1989), Reliability-Based Design of Wood Structures (Vol. 34), Vancouver, BC: Department of Civil Engineering, University of British Columbia.

Wong, S. W., & Zidek, J. V. (2018). Dimensional and statistical foundations for accumulated damage models. Wood science and technology, 52(1), 45-65.

Yang, C. H., Zidek, J. V., & Wong, S. W. (2019). Bayesian analysis of accumulated damage models in lumber reliability. Technometrics, 61(2), 233-245.
}
