\docType{data}
\name{RopeTrick}
\alias{RopeTrick}
\title{Indian Rope Trick}
\format{A data frame with 21 observations on the following 2 variables.
\describe{ \item{years}{a numeric vector}
\item{impressiveness}{a numeric vector} }}
\source{
  Wiseman, R. and P. Lamont. 1996. Unravelling the Indian
  rope-trick. \emph{Nature} 383: 212-213.
}
\description{
  Perceived impressiveness (\code{impressiveness}) of a
  written account of the Indian Rope Trick and the
  corresponding number of \code{year}s since it was
  witnessed.
}
\examples{
data(RopeTrick)
xyplot(impressiveness ~ years, RopeTrick)
}
\references{
  \url{http://www.richardwiseman.com/resources/ropeJSPR.pdf}
}
\keyword{datasets}

