\docType{data}
\name{LarvalFish}
\alias{LarvalFish}
\title{Exploited Larval Fish}
\format{A data frame with 28 observations on the following 3 variables.
\describe{ \item{age}{a numeric vector} \item{cv}{a numeric
vector} \item{exploited}{a factor with levels \code{no} and
\code{yes}} }}
\source{
  Hsieh, C.H., C.S. Reiss, J.R. Hunter, J.R. Beddington,
  R.M. May, and G. Sugihara. 2006. Fishing elevates
  variability in the abundance of exploited species.
  \emph{Nature} 443: 859-862.
}
\description{
  Age (\code{age}) and coefficient of variation (\code{cv})
  in larval fish from exploited and unexploited species
  (\code{exploited}).
}
\examples{
data(LarvalFish)
str(LarvalFish)
xyplot(cv ~ age | exploited, LarvalFish)
xyplot(cv ~ age, groups=exploited, LarvalFish)
}
\keyword{datasets}

