% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.species.R
\name{as.species}
\alias{as.species}
\title{Creates object of "species" class for input into moveSIM() and energySIM()}
\usage{
as.species(
  x = NA,
  y = NA,
  morphpar1 = NA,
  morphpar1mean = NA,
  morphpar1sd = NA,
  morphpar1sign = NA,
  morphpar2 = NA,
  morphpar2mean = NA,
  morphpar2sd = NA,
  morphpar2sign = NA
)
}
\arguments{
\item{x}{Species origin longitude value (degrees). Required.}

\item{y}{Species origin latitude value (degrees). Required.}

\item{morphpar1}{Observed value for morphological parameter 1 (numeric)}

\item{morphpar1mean}{Population mean for morphological parameter 1 (numeric)}

\item{morphpar1sd}{Population standard deviation for morphological parameter 1 (numeric)}

\item{morphpar1sign}{Do higher values of morphpar1 lead to longer or shorter distances traveled each day? Specify "Pos" if longer and "Neg" if shorter.}

\item{morphpar2}{Observed value for morphological parameter 2 (numeric)}

\item{morphpar2mean}{Population mean for morphological parameter 2 (numeric)}

\item{morphpar2sd}{Population standard deviation for morphological parameter 2 (numeric)}

\item{morphpar2sign}{Do higher values of morphpar2 lead to longer or shorter distances traveled each day? Specify "Pos" if longer and "Neg" if shorter.}
}
\value{
Object of class "species" for input into moveSIM() or energySIM()
}
\description{
Here we define the agents whose movement we will be modeling. The user must 
indicate the geographical origin of the agents but can also optionally
specify values of morphological parameters, which will be standardized using
(observed-mean/sd). The standardized values will affect the movement
simulations by serving as a multiplier on "mot_x" and "mot_y" in the
direction specified: "Pos" or "Neg".
}
\details{
In example 1 below, we have a bird with origin (-100,26)
with observed wing chord length of 15 mm, while the population
mean for this measure is 10 mm with a SD of  2 mm (these birds are bigger
than average). We declare morphpar1sign = "Pos" because we assume longer
wingchord length leads to longer flight. Here, "morphpar2" represents mass,
and we want to model heavier than average birds. We assume that heavier birds
will fly longer distance, so specify `morphpar2sign` = `Pos` . If we assumed
that heavier birds will fly shorter distance, we would  specify 
`morphpar2sign`=`"Neg"` to indicate the inverse relationship.
}
\examples{

# Example 1 -- Birds
# -Origin (-100,26)
#-Morphpar1=Wing Chord: Observed=15 mm, Pop. Mean=10, Pop. SD=2; Pos effect
#on movement speed
#-Morphpar2=Mass; Observed=15 g, Pop. Mean=6, Pop. SD=2; Pos effect on
# movement speed

my_species=as.species(x=-100,y=26,morphpar1=15,morphpar1mean=10,
morphpar1sd=2, morphpar1sign="Pos", morphpar2=7,morphpar2mean=6,
morphpar2sd=1,morphpar2sign="Pos")

# Example 2 -- Terrestrial Mammals
#-Origin (-90,40)
#-Morphpar1=Leg length: Observed=1.1 m, Pop. Mean=1, Pop. SD=.2; Pos effect
#on movement speed
#-Morphpar2=Mass; Observed=50 kg, Pop. Mean=55 kg, Pop. SD=10 kg; Neg effect
#on movement speed

my_species2=as.species(x=-90,y=40,morphpar1=1.1,morphpar1mean=1,
morphpar1sd=0.2, morphpar1sign="Pos", morphpar2=50,morphpar2mean=55,
morphpar2sd=10 ,morphpar2sign="Neg")

# Example 3 -- Unspecified agents
# -Origin (-90,40)
# -Not interested in modeling effect of morphology

my_species3=as.species(x=-90,y=40)

}
