% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energyVIZ.R
\name{energyVIZ}
\alias{energyVIZ}
\title{Creates a plot/table of energySIM() results}
\usage{
energyVIZ(
  data,
  type = "plot",
  title = "energySIM results",
  aspect_ratio = 1,
  label = FALSE,
  xlim = NULL,
  ylim = NULL
)
}
\arguments{
\item{data}{Data to be plotted, this object should be the output from
energySIM().}

\item{type}{String from "plot", "gradient", "summary_table", or "strat_table"?}

\item{title}{Title for the plot that is output.}

\item{aspect_ratio}{Aspect ratio, defaults to 1.}

\item{label}{Logical, label the origin and specified final destination?}

\item{xlim}{Optionally specify desired x limits as a numeric vector: c(low,hi)}

\item{ylim}{Optionally specify desired y limits as a numeric vector: c(low,hi)}
}
\value{
Plot or table displaying energySIM() results.
}
\description{
When type="plot", function plots the movement tracks versus the the straight
line track between the origin and destination (unless the destination was
unspecified in the call to energySIM(), then straight line track is omitted).
When type="gradient", creates a gradient plot showing what regions cause
agents to gain/lose energy. Two table  options are also available using
type="summary_table" or type="strat_table" (table with results stratified
by energy gain or loss). Please see Vignette for examples of this output.
}
\examples{

# 1. Define Population and Run energySIM()

pop1 <- as.species(x=-98.7, y=34.7)

EX1=energySIM(replicates=10,days=7,env_rast=ex_raster, search_radius=200,
sigma=.1, dest_x=-108.6, dest_y=26.2, mot_x=.9, mot_y=.9,
modeled_species=pop1,
optimum_lo=.8,optimum_hi=.9,init_energy=100,
direction="R",write_results=FALSE,single_rast=TRUE,mortality = TRUE)

# 2. Run energyVIZ() on your result

energyVIZ(EX1,title="Visualizing EnergySIM results",type="plot", aspect_ratio=5/3,
label=TRUE)

energyVIZ(EX1,type="summary_table")

energyVIZ(EX1,type="strat_table")

# energyVIZ(EX1,type="gradient")

}
