% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abn-internal.R
\name{abn.version}
\alias{abn.version}
\title{abn Version Information}
\usage{
abn.version(what = c("abn", "system"))
}
\arguments{
\item{what}{detailed information about the version of \pkg{abn} or the system (see returns).}
}
\value{
\code{abn.version(what = "system")} is a list with character-string components
\itemize{
\item{R}{\code{R.version.string}}
\item{abn}{essentially \code{abn.version$version.string}}
\item{GSL, JAGS, INLA}{version numbers thereof}
}

\code{abn.version(what = "abn")} is a list with character-string components
\itemize{
\item{status}{the status of the version (e.g., \code{"beta"})}
\item{major}{the major version number}
\item{minor}{the minor version number}
\item{year}{the year the version was released}
\item{month}{the month the version was released}
\item{day}{the day the version was released}
\item{version.string}{a \code{character} string concatenating
the info above, useful for plotting, etc.}
}

\code{abn.version} is a list of class \code{"simple.list"} which has a \code{print} method.
}
\description{
\code{abn.version()} provides detailed information about the running version of \pkg{abn}
or the \pkg{abn} components.
}
\examples{
abn.version()$version.string
\dontrun{
  abn.version("system")
}
}
\seealso{
\code{\link[base]{R.version}}
}
