% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balancing_cost.R
\name{balancing_cost}
\alias{balancing_cost}
\title{Balancing cost accessibility measure}
\usage{
balancing_cost(
  travel_matrix,
  land_use_data,
  opportunity,
  travel_cost,
  demand,
  cost_increment = 1,
  group_by = character(0),
  fill_missing_ids = TRUE
)
}
\arguments{
\item{travel_matrix}{A data frame. The travel matrix describing the costs
(i.e. travel time, distance, monetary cost, etc.) between the origins and
destinations in the study area. Must contain the columns \code{from_id}, \code{to_id}
and any others specified in \code{travel_cost}.}

\item{land_use_data}{A data frame. The distribution of opportunities within
the study area cells. Must contain the columns \code{id} and any others
specified in \code{opportunity}.}

\item{opportunity}{A string. The name of the column in \code{land_use_data}
with the number of opportunities/resources/services to be considered when
calculating accessibility levels.}

\item{travel_cost}{A string. The name of the column in \code{travel_matrix}
with the travel cost between origins and destinations.}

\item{demand}{A string. The name of the column in \code{land_use_data} with the
number of people in each origin that will be considered potential
competitors.}

\item{cost_increment}{A number. The cost increment that should be used when
defining the travel cost distribution from which the potential balancing
costs will be picked. For example, an increment of 1 tends to suitable for
travel time distributions, meaning that the function will first check if
any origins reach their balancing cost with a travel time of 0 minutes,
then 1 minute, 2 minutes, 3, 4, ..., etc. A increment of 1 might be too big
for a distribution of monetary costs, on the other hand, which could
possibly benefit from a smaller increment of 0.05, for example, resulting
in the function looking for balancing costs first at a cost of 0, then
0.05, 0.10, ..., etc. Defaults to 1.}

\item{group_by}{A \code{character} vector. When not \code{character(0)} (the default),
indicates the \code{travel_matrix} columns that should be used to group the
accessibility estimates by. For example, if \code{travel_matrix} includes a
departure time column, that specifies the departure time of each entry in
the data frame, passing \code{"departure_time"} to this parameter results in
accessibility estimates grouped by origin and by departure time.}

\item{fill_missing_ids}{A \code{logical}. When calculating grouped accessibility
estimates (i.e. when \code{by_col} is not \code{NULL}), some combinations of groups
and origins may be missing. For example, if a single trip can depart from
origin \code{A} at 7:15am and reach destination \code{B} within 55 minutes, but no
trips departing from \code{A} at 7:30am can be completed at all, this second
combination will not be included in the output. When \code{TRUE} (the default),
the function identifies which combinations would be left out and fills
their respective accessibility values with 0, which incurs in a
performance penalty.}
}
\value{
A data frame containing the accessibility estimates for each
origin/destination (depending if \code{active} is \code{TRUE} or \code{FALSE}) in the
travel matrix.

A data frame containing the accessibility estimates for each origin
in the travel matrix. Origins marked with a \code{NA} balancing cost never reach
as many opportunities as there is people residing in them, given the
specified travel matrix.
}
\description{
Calculates the balancing cost measure, which is defined as the travel cost
required to reach as many opportunities as the number of people in a given
origin. Originally proposed by
\insertCite{barboza2021balancing;textual}{accessibility}, under the name
"balancing time".

This function is generic over any kind of numeric travel cost,
such as distance, time and money.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data_dir <- system.file("extdata", package = "accessibility")
travel_matrix <- readRDS(file.path(data_dir, "travel_matrix.rds"))
land_use_data <- readRDS(file.path(data_dir, "land_use_data.rds"))

bc <- balancing_cost(
  travel_matrix,
  land_use_data,
  opportunity = "jobs",
  travel_cost = "travel_time",
  demand = "population"
)
head(bc)
\dontshow{\}) # examplesIf}
}
\references{
\insertAllCited{}
}
