% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accucor_lib.R
\name{natural_abundance_correction}
\alias{natural_abundance_correction}
\title{Natural Abundance correction for mass spectrometry data}
\usage{
natural_abundance_correction(
  data,
  sheet = NULL,
  compound_database = NULL,
  output_base = NULL,
  output_filetype = "xlsx",
  columns_to_skip = NULL,
  resolution,
  resolution_defined_at = 200,
  purity = NULL,
  report_pool_size_before_df = FALSE,
  path = NULL
)
}
\arguments{
\item{data}{Path to input data file (xlsx, xls, csv, txt, or tsv) OR
dataframe. If dataframe is specified, specify output_base to output files
automatically written.}

\item{sheet}{Name of sheet in xlsx file with columns 'compound',
'formula', 'isotopelabel', and one column per sample. Defaults to the
first sheet.}

\item{compound_database}{Path to compound database in csv format. Only used
for classic MAVEN style input when formula is not specified.}

\item{output_base}{Path to basename of output file, default is the basename
of the input path. `_corrected` will be appended. If `FALSE` then no
output file is written.}

\item{output_filetype}{Filetype of the output file, one of: 'xls', xlsx',
'csv', or 'tsv'. The default is 'xlsx'.}

\item{columns_to_skip}{Specify column heading to skip. All other columns not
named 'compound', 'formula', and 'isotopelabel' will be assumed to be
sample names.}

\item{resolution}{For Exactive, the resolution is 100000, defined at Mw 200}

\item{resolution_defined_at}{Mw at which the resolution is defined, default
200 Mw}

\item{purity}{Isotope purity, default: Carbon 0.99; Deuterium 0.98;
Nitrogen 0.99}

\item{report_pool_size_before_df}{Report PoolSizeBeforeDF, default = FALSE}

\item{path}{Deprecated. Specify path to input data file (alias for `data`).}
}
\value{
Named list of matrices: 'Corrected', 'Normalized',
  'PoolBeforeDF', and 'PoolAfterDF'.
}
\description{
\code{natural_abundance_correction} returns the corrected and normalized
intensities of isotopically labeled mass spectrometry data. It was designed
to work with input data from
\href{https://elucidatainc.github.io/ElMaven/}{El-MAVEN} and
\href{http://maven.princeton.edu}{MAVEN} software.
}
\details{
C13, H2, and N15 isotopes are supported. The isotopes are detected from the
\code{isotopeLabel} column of the input file. The expected label text is
\code{C13-label-#}. \code{D-label-#}. or \code{N15-label-#}. Parent
(unlabeled) compounds are specified by \code{C12 PARENT}.
}
\examples{
\dontrun{
natural_abundance_correction("inst/extdata/C_Sample_Input_Simple.xlsx",
                             Resolution=100000, ResDefAt=200)
}
}
