% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_transcript.R
\docType{class}
\name{transcript-class}
\alias{transcript-class}
\title{transcript object}
\description{
A transcript object contains the annotations of a loaded annotation file and some meta data .
In addition, it contains information that is auto generated by the act package, which is necessary for some functions (e.g. the full text search)
}
\details{
Some of the slots are defined by the user.
Other slots are \code{[READ ONLY]}, which means that they can be accessed by the user but 
should not be changed. They contain values that are filled when you execute functions 
on the object.
}
\section{Slots}{

\describe{
\item{\code{name}}{Character string; \code{[READ ONLY]} Name of the transcript, generated from the annotation file name.}

\item{\code{file.path}}{Character string; \code{[READ ONLY]} Original location of the annotation file.}

\item{\code{file.encoding}}{Character string; \code{[READ ONLY]} Encoding applied to the file when reading.}

\item{\code{file.type}}{Character string; \code{[READ ONLY]} Type of the original annotation file/object, e.g. 'eaf' or 'textgrid' for files and 'rpraat' for a rPraat .TextGrid object.}

\item{\code{file.content}}{Character string; \code{[READ ONLY]} Content of the original annotation file/object.}

\item{\code{import.result}}{Character string; \code{[READ ONLY]} Information about the success of the import of the annotation file.}

\item{\code{load.message}}{Character string; \code{[READ ONLY]} Possibly messages about errors that occurred on importing the annotation file.}

\item{\code{length}}{Double; \code{[READ ONLY]} Duration of the transcript in seconds.}

\item{\code{tiers}}{Data.frame; \code{[READ ONLY]} Table with the tiers. To modify the tiers it is highly recommended to use functions of the package to ensure for consistency of the data.}

\item{\code{annotations}}{Data.frame; Table with the annotations.}

\item{\code{media.path}}{Character string; Path(s) to the media files that correspond to this transcript object.}

\item{\code{normalization.systime}}{POSIXct; Time of the last normalization.}

\item{\code{fulltext.systime}}{POSIXct; \code{[READ ONLY]} Time of the last creation of the full texts.}

\item{\code{fulltext.filter.tier.names}}{Vector of character strings; names of tiers that were included in the full text..}

\item{\code{fulltext.bytime.orig}}{Character string; \code{[READ ONLY]} full text of the transcript based on the ORIGINAL content of the annotations, sorting the annotations by TIME}

\item{\code{fulltext.bytime.norm}}{Character string; \code{[READ ONLY]} full text of the transcript based on the NORMALIZED content of the annotations, sorting the annotations by TIME}

\item{\code{fulltext.bytier.orig}}{Character string; \code{[READ ONLY]} full text of the transcript based on the ORIGINAL content of the annotations, sorting the annotations first by TIERS and then by time}

\item{\code{fulltext.bytier.norm}}{Character string; \code{[READ ONLY]} full text of the transcript based on the NORMALIZED content of the annotations, sorting the annotations first by TIERS and then by time}

\item{\code{modification.systime}}{POSIXct; \code{[READ ONLY]} Time of the last modification of the transcript. Modifications after importing the annotation file by applying one/some of the packages function(s). Manual changes of the transcript by the user are not tracked!}

\item{\code{history}}{List; \code{[READ ONLY]} History of the modifications made to the transcript object.}
}}

\examples{
library(act)

examplecorpus@transcripts[[1]]

}
