% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcripts_merge2.R
\name{transcripts_merge2}
\alias{transcripts_merge2}
\title{Merge several transcripts (works with transcript objects directly)}
\usage{
transcripts_merge2(
  destinationTranscript,
  updateTranscripts,
  identifierTier = "update",
  identifierPattern = ".+",
  eraseUpdateSectionsCompletely = TRUE
)
}
\arguments{
\item{destinationTranscript}{Transcript object; transcript that serves as destination (and will receive the updates).}

\item{updateTranscripts}{List of transcript objects; transcript objects that will be inserted into the destination transcripts (entirely or in part).}

\item{identifierTier}{Character string;  regular expression that identifies the tier in which the sections are marked, that will be inserted into destinationTranscript.}

\item{identifierPattern}{Character string; regular expression that identifies the sections that will be inserted into destinationTranscript.}

\item{eraseUpdateSectionsCompletely}{Logical; if \code{TRUE} update sections in destination transcript will be erased completely, if \code{FALSE} update sections in the destination tier will not be erased completely but only the tiers that are present in the updateTranscripts be erased.}
}
\value{
Transcript object
}
\description{
Merges several transcripts. One transcript is the destination transcript (the transcript that will be updated).
The other transcripts are the update transcripts and contain the updates.
The update transcripts need to contain a tier in which the update sections are marked with a specific character string.
}
\details{
You may chose between the following two options:
\itemize{
\item The update sections in the destination transcript will first be erased completely and then the updates will be filled in.
\item The update sections in the destination transcript will NOT be erased completely. Rater only the contents of tiers will be erased that are also present in the update tiers. e.g. if your destination transcript contains more tiers than the update transcripts, the contents of those tiers will be preserved in the destination tier during the update.
}
}
\examples{
library(act)

# We need three transcripts  to demonstrate the function \code{transcripts_merge}:
# - the destination transcript
destinationTranscript <- 	examplecorpus@transcripts[["update_destination"]]
# - two transcripts that contain updates
updateTranscripts <- 		c(examplecorpus@transcripts[["update_update1" ]],
                           examplecorpus@transcripts[["update_update2" ]])

# Run the function
test <- transcripts_merge2(destinationTranscript, updateTranscripts)

# Save the transcript to a TextGrid file.
# Set the destination file path
path <- tempfile(pattern = "merge_test", tmpdir = tempdir(),
                 fileext = ".TextGrid")

# It makes more sense, however, to you define a destination folder
# that is easier to access on your computer:
\dontrun{
path <- file.path("PATH_TO_AN_EXISTING_FOLDER_ON_YOUR_COMPUTER",
                    paste(t@name, ".TextGrid", sep=""))
}

# Export
act::export_textgrid( t=test, outputPath=path)

}
\seealso{
\link{transcripts_merge}
}
