% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{checkInactiveness}
\alias{checkInactiveness}
\title{Find if a fish is standing still in an array}
\usage{
checkInactiveness(
  movements,
  fish,
  detections.list,
  inactive.warning,
  inactive.error,
  invalid.dist,
  dist.mat,
  GUI
)
}
\arguments{
\item{movements}{The movements table}

\item{fish}{The fish being analysed}

\item{detections.list}{A list of the detections split by each target tag,
created by \code{\link{splitDetections}}.}

\item{inactive.warning}{If a fish spends a number of days equal or greater
than \code{inactive.error} in a given array at the tail of the respective
detections, a warning is issued. If left NULL (default), no warnings are
issued.}

\item{inactive.error}{If a fish spends a number of days equal or greater than
\code{inactive.error} in a given array at the tail of the respective
detections, user intervention is suggested. If left NULL (default), user
intervention is never suggested.}

\item{GUI}{One of "needed", "always" or "never". If "needed", a new window is
opened to inspect the movements only if the movements table is too big to be
displayed in R's console. If "always", a graphical interface is always created
when the possibility to invalidate events emerges. If "never", a graphical
interface is never invoked. In this case, if the table to be displayed does
not fit in R's console, a temporary file will be saved and the user will be
prompted to open and examine that file. Defaults to "needed".}
}
\value{
A list of movements with updated 'Valid' columns
}
\description{
Find if a fish is standing still in an array
}
\keyword{internal}
