% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotTimes}
\alias{plotTimes}
\title{Print circular graphics for time series.}
\usage{
plotTimes(
  times,
  night = NULL,
  col = NULL,
  alpha = 0.8,
  title = "",
  mean.dash = TRUE,
  mean.range = TRUE,
  rings = TRUE,
  file = NULL
)
}
\arguments{
\item{times}{A list of of time vectors (each vector will be plotted as a series).}

\item{night}{A vector of two times defining the start and stop of the night period (in HH:MM format).}

\item{col}{A vector of colour names to paint each time series (colours will be added transparency).}

\item{alpha}{A value between 0 and 1 for the opacity of each layer (defaults to 0.8).}

\item{title}{A title for the plot.}

\item{mean.dash}{Logical: Should the mean value be displayed on the plot's edge?}

\item{mean.range}{Logical: Should the SEM be displayed? (only relevant if mean.dash = TRUE)}

\item{rings}{Logical: Should inner plot rings be displayed?}

\item{file}{A file name to save the plot as an SVG. Leave NULL to plot on active graphics device.}
}
\value{
A circular plot
}
\description{
Wraps functions adapted from the circular R package.
}
\details{
For more details about the original functions, visit the circular package homepage at \url{https://github.com/cran/circular}
}
\examples{
# The output of timesToCircular can be used as an input to plotTimes.
x <- getTimes(example.results, location = "River1", n.events = "first", event.type = "arrival")
times <- timesToCircular(x)

# plot times
plotTimes(times)

# A night period can be added with 'night'
plotTimes(times, night = c("20:00", "06:00"))

}
