% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_data_with_intensity.R
\name{plot_data_with_intensity}
\alias{plot_data_with_intensity}
\title{Plot accelerometer data for each day with both nonwear time and physical activity intensity categories}
\usage{
plot_data_with_intensity(
  data,
  metric = "axis1",
  col_time = "time",
  col_nonwear = "non_wearing_count",
  col_wear = "wearing_count",
  valid_wear_time_start = "00:00:00",
  valid_wear_time_end = "23:59:00"
)
}
\arguments{
\item{data}{A dataframe obtained using the \code{\link{prepare_dataset}}, \code{\link{mark_wear_time}}, and then the \code{\link{mark_intensity}} functions.}

\item{metric}{A character value to indicate the name of the variable to be plotted against time.}

\item{col_time}{A character value to indicate the name of the variable to plot time data.}

\item{col_nonwear}{A character value to indicate the name of the variable used to count nonwear time.}

\item{col_wear}{A character value to indicate the name of the variable used to count wear time.}

\item{valid_wear_time_start}{A character value with the HH:MM:SS format to set the start of the daily period that will be considered for computing valid wear time.}

\item{valid_wear_time_end}{A character value with the HH:MM:SS format to set the end of the daily period that will be considered for computing valid wear time.}
}
\value{
A \code{ggplot} object.
}
\description{
This function plots accelerometer data with intensity categories against time for each day of measurement,
with the possibility to specify the metric to visualize.
}
\examples{
\donttest{
file <- system.file("extdata", "acc.agd", package = "activAnalyzer")
mydata <- prepare_dataset(data = file)
mydata_with_wear_marks <- mark_wear_time(
    dataset = mydata, 
    TS = "TimeStamp", 
    to_epoch = 60,
    cts  = "vm",
    frame = 90, 
    allowanceFrame = 2, 
    streamFrame = 30
    )
mydata_with_intensity_marks <- mark_intensity(
    data = mydata_with_wear_marks, 
    col_axis = "vm", 
    equation = "Sasaki et al. (2011) [Adults]",
    sed_cutpoint = 200, 
    mpa_cutpoint = 2690, 
    vpa_cutpoint = 6167, 
    age = 32,
    weight = 67,
    sex = "male",
    )
plot_data_with_intensity(
    data = mydata_with_intensity_marks,
    metric = "vm",
    valid_wear_time_start = "00:00:00",
    valid_wear_time_end = "23:59:00"
    )
}

}
