% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{quick_C}
\alias{quick_C}
\title{Covariance of kernel computations}
\usage{
quick_C(measure, design, Ki, Kir, theta, xm, xv, ct, verbose)
}
\arguments{
\item{measure}{An integer giving the measure of integration. 0 for Lebesgue/Uniform on [0,1]^m, 1 for (truncated) Gaussian on [0,1]^m, 2 for Gaussian on R^m.}

\item{design}{matrix of design points}

\item{Ki}{The inverse covariance matrix}

\item{Kir}{The inverse covariance matrix times the response.}

\item{theta}{lengthscales}

\item{xm}{The mean vector associated with the Gaussian measure. Ignored if uniform.}

\item{xv}{The variance vector associated with the Gaussian measure (diagonal of covariance matrix, vars assumed independent). Ignored if uniform.}

\item{ct}{Covariance type, 1 means Gaussian, 2 means Matern 3/2, 3 means Matern 5/2}
}
\value{
The matrix representing the result of the integration.
}
\description{
Computes Int(kappa_i(X, design) . kappa_j(design, X)). This function is preferred for initialization
}
\keyword{internal}
