% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_stats.R
\name{exp_stats}
\alias{exp_stats}
\alias{summary.exp_df}
\title{Summarize experience study records}
\usage{
exp_stats(
  .data,
  target_status = attr(.data, "target_status"),
  expected,
  col_exposure = "exposure",
  col_status = "status",
  wt = NULL,
  credibility = FALSE,
  cred_p = 0.95,
  cred_r = 0.05
)

\method{summary}{exp_df}(object, ...)
}
\arguments{
\item{.data}{a data frame with exposure-level records, ideally of type \code{exposed_df}}

\item{target_status}{a character vector of target status values}

\item{expected}{a character vector containing column names in \code{.data}
with expected values}

\item{col_exposure}{name of the column in \code{.data} containing exposures}

\item{col_status}{name of the column in \code{.data} containing the policy status}

\item{wt}{Optional. Length 1 character vector. Name of the column in
\code{.data} containing weights to use in the calculation of claims,
exposures, and partial credibility.}

\item{credibility}{whether the output should include partial credibility
weights and credibility-weighted decrement rates.}

\item{cred_p}{confidence level under the Limited Fluctuation credibility method}

\item{cred_r}{error tolerance under the Limited Fluctuation credibility
method}

\item{object}{an \code{exp_df} object}

\item{...}{groups to retain after \code{summary()} is called}
}
\value{
A tibble with class \code{exp_df}, \code{tbl_df}, \code{tbl},
and \code{data.frame}. The results include columns for any grouping
variables, claims, exposures, and observed decrement rates (\code{q_obs}).
If any values are passed to \code{expected}, additional columns will be
added for expected decrements and actual-to-expected ratios. If
\code{credibility} is set to \code{TRUE}, additional columns are added
for partial credibility and credibility-weighted decrement rates
(assuming values are passed to \code{expected}).
}
\description{
Create a summary data frame of termination experience for a
given target status.
}
\details{
If \code{.data} is grouped, the resulting data frame will contain
one row per group.

If \code{target_status} isn't provided, \code{\link[=exp_stats]{exp_stats()}} will use the same
target status from \code{.data} if it has the class \code{exposed_df}.
Otherwise, \code{.data} is not an \code{exposed_df} object, all status
values except the first level will be assumed. This will produce a
warning message.
}
\section{Expected values}{
The \code{expected} argument is optional. If provided, this argument must
be a character vector with values corresponding to columns in \code{.data}
containing expected experience. More than one expected basis can be provided.
}

\section{Credibility}{
If \code{credibility} is set to \code{TRUE}, the output will contain a
\code{credibility} column equal to the partial credibility estimate under
the Limited Fluctuation credibility method (also known as Classical
Credibility) assuming a binomial distribution of claims.
}

\section{\code{summary()} Method}{
Applying \code{summary()} to a \code{exp_df} object will re-summarize the
data while retaining any grouping variables passed to the "dots"
(\code{...}).
}

\examples{
toy_census |> expose("2020-12-31", target_status = "Surrender") |>
    exp_stats()

exp_res <- census_dat |>
           expose("2019-12-31", target_status = "Surrender") |>
           group_by(pol_yr, inc_guar) |>
           exp_stats()

exp_res
summary(exp_res)
summary(exp_res, inc_guar)

}
\references{
Herzog, Thomas (1999). Introduction to Credibility Theory
}
