% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_special.R
\name{plot_special}
\alias{plot_special}
\alias{plot_termination_rates}
\alias{plot_actual_to_expected}
\title{Additional plotting functions for termination studies}
\usage{
plot_termination_rates(object, ..., include_cred_adj = FALSE)

plot_actual_to_expected(object, ..., add_hline = TRUE)
}
\arguments{
\item{object}{An object of class \code{exp_df} created by the function
\code{\link[=exp_stats]{exp_stats()}}.}

\item{...}{Additional arguments passed to \code{\link[=autoplot.exp_df]{autoplot.exp_df()}}.}

\item{include_cred_adj}{If \code{TRUE}, credibility-weighted termination rates
will be plotted as well.}

\item{add_hline}{If \code{TRUE}, a blue dashed horizontal line will be drawn at
100\%.}
}
\value{
a \code{ggplot} object
}
\description{
These functions create additional experience study plots that are not
available or difficult to produce using the \code{\link[=autoplot.exp_df]{autoplot.exp_df()}} function.
}
\details{
\code{\link[=plot_termination_rates]{plot_termination_rates()}} - Create a plot of observed termination rates
and any expected termination rates attached to an \code{exp_df} object.

\code{\link[=plot_actual_to_expected]{plot_actual_to_expected()}} - Create a plot of actual-to-expected termination
rates attached to an \code{exp_df} object.
}
\examples{

study_py <- expose_py(census_dat, "2019-12-31", target_status = "Surrender")
expected_table <- c(seq(0.005, 0.03, length.out = 10), 0.2, 0.15, rep(0.05, 3))

study_py <- study_py |>
  mutate(expected_1 = expected_table[pol_yr],
         expected_2 = ifelse(inc_guar, 0.015, 0.03))

exp_res <- study_py |> group_by(pol_yr) |>
  exp_stats(expected = c("expected_1", "expected_2"))

plot_termination_rates(exp_res)

plot_actual_to_expected(exp_res)

}
\seealso{
\code{\link[=autoplot.exp_df]{autoplot.exp_df()}}
}
