% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_clean_multiv.R
\name{do_clean_multiv}
\alias{do_clean_multiv}
\title{Cleaning multivariate functional outliers}
\usage{
do_clean_multiv(data, num_pts, range = 1.5, out_perc = 80, nbasis, nvars)
}
\arguments{
\item{data}{Data frame with (temporal) points in the rows and observations in 
the columns.}

\item{num_pts}{Number of temporal points.}

\item{range}{Same parameter as in function \code{\link{boxplot}}. 
A value of 1.5 is enough to detect amplitude and shift outliers, while a value
of 3 is needed to detect isolated outliers.}

\item{out_perc}{Minimum number of temporal points (in percentage) to consider 
the observation as an outlier. Needed when \code{range=1.5}.}

\item{nbasis}{Number of basis.}

\item{nvars}{Number of variables.}
}
\value{
List with the outliers for each variable.
}
\description{
Cleaning of the most remarkable multivariate functional outliers. 
This improves the performance of the archetypoid algorithm since it 
is not affected by spurious points.
}
\examples{
\dontrun{
library(fda)
?growth
str(growth)
hgtm <- growth$hgtm
hgtf <- growth$hgtf[,1:39]

# Create array:
nvars <- 2
data.array <- array(0, dim = c(dim(hgtm), nvars))
data.array[,,1] <- as.matrix(hgtm)
data.array[,,2] <- as.matrix(hgtf)
rownames(data.array) <- 1:nrow(hgtm)
colnames(data.array) <- colnames(hgtm)
str(data.array)

# Create basis:
nbasis <- 10
basis_fd <- create.bspline.basis(c(1,nrow(hgtm)), nbasis)
PM <- eval.penalty(basis_fd)
# Make fd object:
temp_points <- 1:nrow(hgtm)
temp_fd <- Data2fd(argvals = temp_points, y = data.array, basisobj = basis_fd)

X <- array(0, dim = c(dim(t(temp_fd$coefs[,,1])), nvars))
X[,,1] <- t(temp_fd$coef[,,1]) 
X[,,2] <- t(temp_fd$coef[,,2])

# Standardize the variables:
Xs <- X
Xs[,,1] <- scale(X[,,1])
Xs[,,2] <- scale(X[,,2])

x1 <- t(Xs[,,1]) 
for (i in 2:nvars) { 
 x12 <- t(Xs[,,i]) 
 x1 <- rbind(x1, x12) 
}
data_all <- t(x1) 

num_pts <- ncol(data_all) / nvars
range <- 3 
outl <- do_clean_multiv(t(data_all), num_pts, range, out_perc, nbasis, nvars)
outl
}
                  
}
\seealso{
\code{\link{boxplot}}
}
\author{
Irene Epifanio
}
