% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasso_perm.R
\name{lasso_perm}
\alias{lasso_perm}
\title{fit a lasso regression and use standard permutation of the outcome for variable selection}
\usage{
lasso_perm(x, y, K = 20, keep = NULL, betaPos = TRUE, ncore = 1, ...)
}
\arguments{
\item{x}{Input matrix, of dimension nobs x nvars. Each row is an observation
vector. Can be in sparse matrix format (inherit from class
\code{"sparseMatrix"} as in package \code{Matrix}).}

\item{y}{Binary response variable, numeric.}

\item{K}{Number of permutations of \code{y}. Default is 20.}

\item{keep}{Do some variables of \code{x} have to be permuted in the same way
as \code{y}? Default is NULL, means no.
If yes, must be a vector of covariates indices. TEST OPTION}

\item{betaPos}{Should the covariates selected by the procedure be positively
associated with the outcome ? Default is \code{TRUE}.}

\item{ncore}{The number of calcul units used for parallel computing.
Default is 1, no parallelization is implemented.}

\item{\dots}{Other arguments that can be passed to \code{glmnet}
from package \code{glmnet} other than \code{family}.}
}
\value{
An object with S3 class \code{"log.lasso"}.
\item{beta}{Numeric vector of regression coefficients in the lasso
In \code{lasso_perm} function, the regression coefficients are PENALIZED.
Length equal to nvars.}
\item{selected_variables}{Character vector, names of variable(s) selected with the
lasso-perm approach.
If \code{betaPos = TRUE}, this set is the covariates with a positive regression
coefficient in \code{beta}.
Else this set is the covariates with a non null regression coefficient in
\code{beta}.
Covariates are ordering according to magnitude of their regression
coefficients absolute value.}
}
\description{
Performed K lasso logistic regression with K different permuted version of the outcome.
For earch of the lasso regression, the \eqn{\lambda_max}(i.e. the smaller
\eqn{\lambda} such as all penalized regression coefficients are shrunk to zero)
is obtained.
The median value of these K  \eqn{\lambda_max} is used to for variable selection
in the lasso regression with the non-permuted outcome.
Depends on the \code{glmnet} function from the package \code{glmnet}.
}
\details{
The selected \eqn{\lambda} with this approach is defined as the closest
\eqn{\lambda} from the median value of the K \eqn{\lambda_max} obtained
with permutation of the outcome.
}
\examples{

set.seed(15)
drugs <- matrix(rbinom(100*20, 1, 0.2), nrow = 100, ncol = 20)
colnames(drugs) <- paste0("drugs",1:ncol(drugs))
ae <- rbinom(100, 1, 0.3)
lp <- lasso_perm(x = drugs, y = ae, K = 10)


}
\references{
Sabourin, J. A., Valdar, W., & Nobel, A. B. (2015). "A permutation approach for selecting the penalty parameter in penalized model selection".
\emph{Biometrics}. 71(4), 1185–1194, \url{https://doi.org/10.1111/biom.12359}
}
\author{
Emeline Courtois \cr Maintainer: Emeline Courtois
\email{emeline.courtois@inserm.fr}
}
