% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ys_and_draws.R
\name{get_draws_norm}
\alias{get_draws_norm}
\title{Generate draws from posterior normal distributions}
\usage{
get_draws_norm(arms, allocs, ys, control, n_draws)
}
\arguments{
\item{arms}{character vector, \strong{currently active} \code{arms} as specified in
\code{\link[=setup_trial]{setup_trial()}} / \code{\link[=setup_trial_binom]{setup_trial_binom()}} / \code{\link[=setup_trial_norm]{setup_trial_norm()}}.}

\item{allocs}{character vector, allocations of all patients (including
allocations to \strong{currently inactive} \code{arms}).}

\item{ys}{numeric vector, outcomes of all patients in the same order
as \code{alloc} (including outcomes of patients in \strong{currently inactive}
\code{arms}).}

\item{control}{unused argument in the built-in functions for
\code{\link[=setup_trial_binom]{setup_trial_binom()}} and \link{setup_trial_norm}, but required as this
argument is supplied by the \code{\link[=run_trial]{run_trial()}} function, and may be used in
user-defined functions used to generate posterior draws.}

\item{n_draws}{single integer, number of posterior draws.}
}
\value{
A \code{matrix} (with numeric values) with \code{length(arms)} columns and
\code{n_draws} rows, with \code{arms} as column names.
}
\description{
Used internally. This function generates draws from posterior, normal
distributions for continuous outcomes. Technically, these posteriors use no
priors (for simulation speed), corresponding to the use of improper flat
priors. These posteriors correspond (and give similar results) to using
normal-normal models (normally distributed outcome, conjugate normal prior)
for each arm, assuming that a non-informative, flat prior is used. Thus, the
posteriors directly correspond to normal distributions with each groups' mean
as the mean and each groups' standard error as the standard deviation.
As it is necessary to always return valid draws, in cases where \verb{< 2}
patients have been randomised to an \code{arm}, posterior draws will come from an
extremely wide normal distribution with mean corresponding to the mean of all
included patients with outcome data and a standard deviation corresponding to
the difference between the highest and lowest recorded outcomes for all
patients with available outcome data multiplied by \code{1000}.
}
\keyword{internal}
