% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driver_void.R
\name{adbc_driver_void}
\alias{adbc_driver_void}
\alias{adbc_driver}
\title{Create ADBC drivers}
\usage{
adbc_driver_void()

adbc_driver(x, entrypoint = NULL, ..., subclass = character())
}
\arguments{
\item{x, entrypoint}{An ADBC driver may be defined either as an init function
or as an identifier with an entrypoint name. A driver init func
must be an external pointer to a DL_FUNC with the type
\code{AdbcDriverInitFunc} specified in the adbc.h header.}

\item{...}{Further key/value parameters to store with the (R-level) driver
object.}

\item{subclass}{An optional subclass for finer-grained control of
behaviour at the R level.}
}
\value{
An object of class 'adbc_driver'
}
\description{
Creates the R object representation of an ADBC driver, which consists of a
name and an initializer function with an optional subclass to control
finer-grained behaviour at the R level.
}
\examples{
adbc_driver_void()

}
