% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarityMatrix.R
\name{similarityMatrix}
\alias{similarityMatrix}
\title{ADEPT Similarity Matrix Computation}
\usage{
similarityMatrix(x, template.scaled, similarity.measure)
}
\arguments{
\item{x}{A numeric vector. A time-series \code{x}.}

\item{template.scaled}{A list of lists of numeric vectors, as returned by
\code{scaleTemplate}.  Each element of
\code{template.scaled}
is a list of templates interpolated to a particular vector length.
 Number of elements in the \code{template.scaled}  corresponds to the
 number of unique template length values used in segmentation.}

\item{similarity.measure}{A character scalar. Statistic
used in similarity matrix computation; one of the following:
\itemize{
  \item "cov" - for covariance,
  \item "cor" - for correlation.
}}
}
\value{
A numeric matrix. Contains values of similarity between a time-series \code{x}
and scaled templates.
\itemize{
  \item Number of rows equals \code{template.scaled} length,
  number of columns equals \code{x}  length.
  \item A particular matrix row consists of similarity statistic
  between \code{x} and a template rescaled to a particular vector length.
  Precisely, each row's element is a maximum out of similarity values
 computed for each distinct template used in segmentation.
}
}
\description{
Compute ADEPT similarity matrix between a time-series \code{x} and a collection
of scaled templates.
}
\examples{
## Simulate data
par(mfrow = c(1,1))
x0 <- sin(seq(0, 2 * pi * 100, length.out = 10000))
x  <- x0 + rnorm(1000, sd = 0.1)
template <- list(x0[1:500])
template.vl <- seq(300, 700, by = 50)

## Rescale pattern
template.scaled <- scaleTemplate(template, template.vl)

## Compute ADEPT similarity matrix
out <- similarityMatrix(x, template.scaled, "cov")

## Visualize
par(mfrow = c(1,1))
image(t(out),
      main = "ADEPT similarity matrix\\nfor time-series x and scaled versions of pattern templates",
      xlab = "Time index",
      ylab = "Pattern vector length",
      xaxt = "n", yaxt = "n")
xaxis <- c(1, seq(1000, length(x0), by = 1000))
yaxis <- template.vl
axis(1, at = xaxis/max(xaxis), labels = xaxis)
axis(2, at = (yaxis - min(yaxis))/(max(yaxis) - min(yaxis)), labels = yaxis)

}
\seealso{
\code{scaleTemplate {adept}}
}
