% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02amigaDiskBasics.r
\docType{class}
\name{amigaDisk-class}
\alias{amigaDisk-class}
\alias{amigaDisk}
\title{The amigaDisk class}
\description{
An S4 class representing the information from an Amiga Disk File.
}
\details{
An Amiga Disk File (ADF) holds the raw data of an Amiga disk
in the same order as blocks (\code{\linkS4class{amigaBlock}})
on the physical disks. As an Amiga
Disk can hold any kind of information, so can this class.

An ADF file does not hold any other information. The size of
the file will dictate whether it represents a double density
floppy disk (880 kB) or a high density floppy disk (1760 kB).
The disk type is also stored in this class.

Finally, the current directory is stored with this class. Which
is only useful for DOS-formatted disks (with a file structure).
By default this is set to the disk's root.

For more (technical) backgrounds please check this package's vignette
(\code{vignette("amigaDiskFiles")})

Use the objects constructor (\code{new("amigaDisk")}) to create
a completely blank disk (without a filesystem). If you want to be
able to transfer files from and to the virtual disk, use
\code{\link{blank.amigaDOSDisk}} instead.
}
\section{Slots}{

\describe{
\item{\code{data}}{The \code{raw} data of the virtual disk. It should be
a \code{vector} of length 901,120 in case of a double density disk and
1,802,240 in case of a high density disk.}

\item{\code{type}}{A \code{character} indicating whether the virtual disk
represents a \code{"DD"} (double density, most common) or \code{"HD"} (high density)
disk.}

\item{\code{current.dir}}{An \code{integer}, pointing at the block address
of the current directory of this virtual disk. Use
\code{\link{current.adf.dir}} to get or set the current directory.}
}}

\examples{
## This creates a blank non-bootable, non-DOS disk:
new("amigaDisk")
}
\author{
Pepijn de Vries
}
\concept{amiga.disk.access}
