% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjroc.R
\name{adjroc}
\alias{adjroc}
\title{adjroc}
\usage{
adjroc(
  score,
  class,
  method = "emp",
  sensitivity = NULL,
  specificity = NULL,
  plot = FALSE
)
}
\arguments{
\item{score}{A numeric array of diagnostic score i.e. the estimated probability of each diagnosis}

\item{class}{A numeric array of equal length of \code{"score"}, including the actual class of the observations}

\item{method}{Specifies the method for estimating the ROC curve. Three methods are supported, which are \code{"empirical"}, \code{"binormal"}, and \code{"nonparametric"}}

\item{sensitivity}{numeric. Specify the threshold of sensitivity}

\item{specificity}{numeric. Specify the threshold of specificity}

\item{plot}{logical. if TRUE, the sensitivity and specificity will be plotted}
}
\value{
data.frame including cutoff point, and adjusted sensitivity and specificity
    based on the specified threshold
}
\description{
computes adjusted sensitivity, adjusted specificity, or the crossing
    point between sensitivity and specificity for different thresholds
}
\examples{
# random classification and probability score
score <- runif(10000, min=0, max=1)
class <- sample(x = c(1,0), 10000, replace=TRUE)

# calculate adjusted sensitivity, when specificity threshold is 0.90:
adjroc(score = score, class = class, specificity = 0.9, plot = TRUE)

# calculate adjusted specificity, when sensitivity threshold equals 0.9
adjroc(score = score, class = class, sensitivity = 0.9, plot = TRUE)

# calculate the meeting point between sensitivity and specificity
adjroc(score = score, class = class, plot = TRUE)
}
