% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admiral_options.R
\name{set_admiral_options}
\alias{set_admiral_options}
\title{Set the Value of admiral Options}
\usage{
set_admiral_options(subject_keys, signif_digits, save_memory)
}
\arguments{
\item{subject_keys}{Variables to uniquely identify a subject, defaults to
\code{exprs(STUDYID, USUBJID)}. This option is used as default value for the
\code{subject_keys} argument in all admiral functions.}

\item{signif_digits}{Holds number of significant digits when comparing to numeric variables,
defaults to \code{15}. This option is used as default value for the  \code{signif_dig} argument in
admiral functions \code{derive_var_atoxgr_dir()} and \code{derive_var_anrind()}.}

\item{save_memory}{If set to \code{TRUE}, an alternative algorithm is used in the
functions \code{derive_vars_joined()}, \code{derive_var_joined_exist_flag()},
\code{derive_extreme_event()}, and \code{filter_joined()} which requires less memory
but more run-time.}
}
\value{
No return value, called for side effects.
}
\description{
Set the values of admiral options that can be modified for advanced users.
}
\details{
Modify an admiral option, e.g \code{subject_keys}, such that it automatically affects downstream
function inputs where \code{get_admiral_option()} is called such as \code{derive_param_exist_flag()}.
}
\examples{
library(lubridate)
library(dplyr, warn.conflicts = FALSE)
library(tibble)
set_admiral_options(subject_keys = exprs(STUDYID, USUBJID2))

# Derive a new parameter for measurable disease at baseline
adsl <- tribble(
  ~USUBJID2,
  "1",
  "2",
  "3"
) \%>\%
  mutate(STUDYID = "XX1234")

tu <- tribble(
  ~USUBJID2,      ~VISIT,    ~TUSTRESC,
  "1",       "SCREENING",     "TARGET",
  "1",          "WEEK 1",     "TARGET",
  "1",          "WEEK 5",     "TARGET",
  "1",          "WEEK 9", "NON-TARGET",
  "2",       "SCREENING", "NON-TARGET",
  "2",       "SCREENING", "NON-TARGET"
) \%>\%
  mutate(
    STUDYID = "XX1234",
    TUTESTCD = "TUMIDENT"
  )

derive_param_exist_flag(
  dataset_ref = adsl,
  dataset_add = tu,
  filter_add = TUTESTCD == "TUMIDENT" & VISIT == "SCREENING",
  condition = TUSTRESC == "TARGET",
  false_value = "N",
  missing_value = "N",
  set_values_to = exprs(
    PARAMCD = "MDIS",
    PARAM = "Measurable Disease at Baseline"
  )
)

set_admiral_options(signif_digits = 14)

# Derive ANRIND for ADVS
advs <- tribble(
  ~PARAMCD, ~AVAL, ~ANRLO, ~ANRHI,
  "DIABP",     59,     60,     80,
  "SYSBP",    120,     90,    130,
  "RESP",      21,      8,     20,
)

derive_var_anrind(advs)

}
\seealso{
\code{\link[=get_admiral_option]{get_admiral_option()}}, \code{\link[=derive_param_exist_flag]{derive_param_exist_flag()}},\code{\link[=derive_param_tte]{derive_param_tte()}},
\code{\link[=derive_var_dthcaus]{derive_var_dthcaus()}}, \code{\link[=derive_var_extreme_dtm]{derive_var_extreme_dtm()}}, \code{\link[=derive_vars_period]{derive_vars_period()}},
\code{\link[=create_period_dataset]{create_period_dataset()}}, \code{\link[=derive_var_atoxgr_dir]{derive_var_atoxgr_dir()}}, \code{\link[=derive_var_anrind]{derive_var_anrind()}}

Other admiral_options: 
\code{\link{get_admiral_option}()}
}
\concept{admiral_options}
\keyword{admiral_options}
