% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmp_vars.R
\name{get_new_tmp_var}
\alias{get_new_tmp_var}
\title{Get a New Temporary Variable Name for a Dataset}
\usage{
get_new_tmp_var(dataset, prefix = "tmp_var")
}
\arguments{
\item{dataset}{The input dataset}

\item{prefix}{The prefix of the new temporary variable name to create}
}
\value{
The name of a new temporary variable as a symbol
}
\description{
Get a New Temporary Variable Name for a Dataset
}
\details{
The function returns a new unique temporary variable name to be used inside
\code{dataset}. The temporary variable names have the structure \code{prefix_n} where
\code{n} is an integer, e.g. \code{tmp_var_1}. If there is already a variable inside
\code{datset} with a given \code{prefix} then the suffix is increased by 1, e.g. if
\code{tmp_var_1} already exists then \code{get_new_tmp_var()} will return \code{tmp_var_2}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data(admiral_dm)

tmp_var <- get_new_tmp_var(admiral_dm)
mutate(admiral_dm, !!tmp_var := NA)
}
\seealso{
\code{\link[=remove_tmp_vars]{remove_tmp_vars()}}
}
\keyword{tmp_vars}
