% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_lasta.R
\name{derive_param_lasta}
\alias{derive_param_lasta}
\title{Adds a Parameter for the Last Disease Assessment}
\usage{
derive_param_lasta(
  dataset,
  filter_source,
  order = vars(ADT),
  source_pd = NULL,
  source_datasets = NULL,
  subject_keys = get_admiral_option("subject_keys"),
  set_values_to
)
}
\arguments{
\item{dataset}{Input dataframe from which the Last Disease Assessment will be
be derived from and added to.

The column \code{PARAMCD} and the columns specified in \code{subject_keys} and
\code{order} are expected.

After applying \code{filter_source} and/or \code{source_pd} the columns specified by
\code{subject_keys} and \code{order} must be a unique key of the dataframe

\emph{Permitted Values:} a \code{data.frame()} object}

\item{filter_source}{Filter to be applied to \code{dataset} to derive the
Last Disease Assessment}

\item{order}{Sort order, after which the last record shall be taken by
the \code{subject_keys} to determine Last Disease Assessment. Created
using \code{vars()}.

\emph{Permitted Values:} list of variables or \verb{desc(<variable>)} function calls
created by \code{vars()}, e.g., \code{vars(ADT, desc(AVAL))}}

\item{source_pd}{Date of first progressive disease (PD)

If the parameter is specified, the observations of the input \code{dataset} for
deriving the new parameter are restricted to observations up to the
specified date. Observations at the specified date are included. For
subjects without first PD date all observations are take into account.

\emph{Permitted Values:} a \code{date_source} object (see \code{date_source()}
for details)}

\item{source_datasets}{Source dataframe to be used to calculate the
first PD date

A named list of dataframes is expected (although for BOR) only one dataframe is
needed. It links the \code{dataset_name} from \code{source_pd} with an existing dataframe.

For example if \code{source_pd = pd_date} with

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pd_date <- date_source(
  dataset_name = "adrs",
  date = ADT,
  filter = PARAMCD == PD
)
}\if{html}{\out{</div>}}

and the actual response dataframe in the script is \code{myadrs}, \code{source_datasets = list(adrs = myadrs)} should be specified.}

\item{subject_keys}{Columns to uniquely identify a subject

A list of symbols created using \code{vars()}.}

\item{set_values_to}{Columns to set

A named list returned by \code{vars()} defining the columns to be set for the
new parameter, e.g. \code{vars(PARAMCD = "LSTAC", PARAM = "Last Disease Assessment Censored at First PD by Investigator")} is expected. The values
must be symbols, character strings, numeric values, or \code{NA}.}
}
\value{
The dataframe passed in the \code{dataset} argument with additional
columns and/or rows as set in the \code{set_values_to} argument.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is \emph{deprecated}, please use \code{admiral::derive_param_extreme_event()} instead.
}
\details{
Calculates the last disease assessment by accessing the last record
defined in \code{subject_keys} after it has been arranged using the \code{order} argument.

Creates a new parameter record (keeping all columns passed) from the last source
record (i.e. the last record defined in \code{subject_keys} after it has been arranged
using the \code{order} argument). One new record for each subject in the filtered
input \code{dataset} is added to the input \code{dataset}.

Records after PD can be removed using the \code{source_pd} and \code{source_datasets}
arguments.
}
\author{
Stephen Gormley
}
\concept{deprecated}
\keyword{deprecated}
